/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.cacheservice;

import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.utils.JsonUtils;
import cn.com.duiba.wolf.redis.RedisClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ActivityCacheService {
    @Autowired
    private RedisClient redisClient;

    public ActivityDto get(Long activityId, Integer activityType) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey((String)(activityId + "-" + activityType));
        String value = this.redisClient.get(key);
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        return JsonUtils.jsonToObject(ActivityDto.class, value);
    }

    public void set(ActivityDto activityDto) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey((String)(activityDto.getActivityId() + "-" + activityDto.getActivityType()));
        String value = JsonUtils.objectToString((Object)activityDto);
        this.redisClient.set(key, value);
    }
}

