/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.utils;

import cn.com.duiba.tuia.media.utils.RequestLocal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    private CookieUtil cu;

    public CookieUtil getCookieUtil() {
        if (this.cu == null) {
            this.cu = new CookieUtil();
        }
        return this.cu;
    }

    public static Cookie createCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        return cookie;
    }

    public static void setWildcardCookie(String name, String value) {
        CookieUtil.setCookie(name, value);
    }

    public static void setCookie(String name, String value) {
        Cookie cookie = CookieUtil.createCookie(name, value);
        RequestLocal.get().getResponse().addCookie(cookie);
    }

    public static Cookie createCrossCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        return cookie;
    }

    public static void setCrossCookie(String name, String value) {
        Cookie cookie = CookieUtil.createCrossCookie(name, value);
        RequestLocal.get().getResponse().addCookie(cookie);
    }

    public static void deleteWildcardCookie(String name) {
        Cookie cookie = CookieUtil.createCookie(name, null);
        cookie.setMaxAge(0);
        RequestLocal.get().getResponse().addCookie(cookie);
    }

    public static void deleteCookie(String name) {
        Cookie cookie = CookieUtil.createCookie(name, null);
        cookie.setMaxAge(0);
        RequestLocal.get().getResponse().addCookie(cookie);
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = CookieUtil.readCookieMap(request);
        if (cookieMap.containsKey(name)) {
            return cookieMap.get(name);
        }
        return null;
    }

    private static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }
}

