/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.remoting.protocol;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.rocketmq.remoting.CommandCustomHeader;
import com.alibaba.rocketmq.remoting.annotation.CFNotNull;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommandType;
import com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import com.alibaba.rocketmq.remoting.protocol.RocketMQSerializable;
import com.alibaba.rocketmq.remoting.protocol.SerializeType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingCommand {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    public static String RemotingVersionKey = "rocketmq.remoting.version";
    public static final String SERIALIZE_TYPE_PROPERTY = "rocketmq.serialize.type";
    public static final String SERIALIZE_TYPE_ENV = "ROCKETMQ_SERIALIZE_TYPE";
    private static volatile int ConfigVersion = -1;
    private static AtomicInteger RequestId = new AtomicInteger(0);
    private static final int RPC_TYPE = 0;
    private static final int RPC_ONEWAY = 1;
    private int code;
    private LanguageCode language = LanguageCode.JAVA;
    private int version = 0;
    private int opaque = RequestId.getAndIncrement();
    private int flag = 0;
    private String remark;
    private HashMap<String, String> extFields;
    private transient CommandCustomHeader customHeader;
    private static final Map<Class<? extends CommandCustomHeader>, Field[]> clazzFieldsCache = new HashMap<Class<? extends CommandCustomHeader>, Field[]>();
    private static final Map<Class, String> canonicalNameCache = new HashMap<Class, String>();
    private static final Map<Field, Annotation> notNullAnnotationCache = new HashMap<Field, Annotation>();
    private static SerializeType SerializeTypeConfigInThisServer = SerializeType.JSON;
    private SerializeType serializeTypeCurrentRPC = SerializeTypeConfigInThisServer;
    private transient byte[] body;
    private static final String StringCanonicalName;
    private static final String DoubleCanonicalName1;
    private static final String DoubleCanonicalName2;
    private static final String IntegerCanonicalName1;
    private static final String IntegerCanonicalName2;
    private static final String LongCanonicalName1;
    private static final String LongCanonicalName2;
    private static final String BooleanCanonicalName1;
    private static final String BooleanCanonicalName2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field[] getClazzFields(Class<? extends CommandCustomHeader> classHeader) {
        Field[] field = clazzFieldsCache.get(classHeader);
        if (field == null) {
            field = classHeader.getDeclaredFields();
            Map<Class<? extends CommandCustomHeader>, Field[]> map = clazzFieldsCache;
            synchronized (map) {
                clazzFieldsCache.put(classHeader, field);
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCanonicalName(Class clazz) {
        String name = canonicalNameCache.get(clazz);
        if (name == null) {
            name = clazz.getCanonicalName();
            Map<Class, String> map = canonicalNameCache;
            synchronized (map) {
                canonicalNameCache.put(clazz, name);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Annotation getNotNullAnnotation(Field field) {
        Annotation annotation = notNullAnnotationCache.get(field);
        if (annotation == null) {
            annotation = field.getAnnotation(CFNotNull.class);
            Map<Field, Annotation> map = notNullAnnotationCache;
            synchronized (map) {
                notNullAnnotationCache.put(field, annotation);
            }
        }
        return annotation;
    }

    protected RemotingCommand() {
    }

    public static RemotingCommand createRequestCommand(int code, CommandCustomHeader customHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        cmd.customHeader = customHeader;
        RemotingCommand.setCmdVersion(cmd);
        return cmd;
    }

    public static RemotingCommand createResponseCommand(Class<? extends CommandCustomHeader> classHeader) {
        RemotingCommand cmd = RemotingCommand.createResponseCommand(1, "not set any response code", classHeader);
        return cmd;
    }

    public static RemotingCommand createResponseCommand(int code, String remark) {
        return RemotingCommand.createResponseCommand(code, remark, null);
    }

    public static RemotingCommand createResponseCommand(int code, String remark, Class<? extends CommandCustomHeader> classHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.markResponseType();
        cmd.setCode(code);
        cmd.setRemark(remark);
        RemotingCommand.setCmdVersion(cmd);
        if (classHeader != null) {
            try {
                CommandCustomHeader objectHeader;
                cmd.customHeader = objectHeader = classHeader.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return cmd;
    }

    private static void setCmdVersion(RemotingCommand cmd) {
        if (ConfigVersion >= 0) {
            cmd.setVersion(ConfigVersion);
        } else {
            String v = System.getProperty(RemotingVersionKey);
            if (v != null) {
                int value = Integer.parseInt(v);
                cmd.setVersion(value);
                ConfigVersion = value;
            }
        }
    }

    public void makeCustomHeaderToNet() {
        if (this.customHeader != null) {
            Field[] fields = this.getClazzFields(this.customHeader.getClass());
            if (null == this.extFields) {
                this.extFields = new HashMap();
            }
            for (Field field : fields) {
                String name;
                if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
                Object value = null;
                try {
                    field.setAccessible(true);
                    value = field.get(this.customHeader);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                if (value == null) continue;
                this.extFields.put(name, value.toString());
            }
        }
    }

    public CommandCustomHeader readCustomHeader() {
        return this.customHeader;
    }

    public void writeCustomHeader(CommandCustomHeader customHeader) {
        this.customHeader = customHeader;
    }

    public CommandCustomHeader decodeCommandCustomHeader(Class<? extends CommandCustomHeader> classHeader) throws RemotingCommandException {
        CommandCustomHeader objectHeader;
        try {
            objectHeader = classHeader.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (this.extFields != null) {
            Field[] fields;
            for (Field field : fields = this.getClazzFields(classHeader)) {
                String fieldName;
                if (Modifier.isStatic(field.getModifiers()) || (fieldName = field.getName()).startsWith("this")) continue;
                try {
                    Object valueParsed;
                    String value = this.extFields.get(fieldName);
                    if (null == value) {
                        Annotation annotation = this.getNotNullAnnotation(field);
                        if (annotation == null) continue;
                        throw new RemotingCommandException("the custom field <" + fieldName + "> is null");
                    }
                    field.setAccessible(true);
                    String type = this.getCanonicalName(field.getType());
                    if (type.equals(StringCanonicalName)) {
                        valueParsed = value;
                    } else if (type.equals(IntegerCanonicalName1) || type.equals(IntegerCanonicalName2)) {
                        valueParsed = Integer.parseInt(value);
                    } else if (type.equals(LongCanonicalName1) || type.equals(LongCanonicalName2)) {
                        valueParsed = Long.parseLong(value);
                    } else if (type.equals(BooleanCanonicalName1) || type.equals(BooleanCanonicalName2)) {
                        valueParsed = Boolean.parseBoolean(value);
                    } else if (type.equals(DoubleCanonicalName1) || type.equals(DoubleCanonicalName2)) {
                        valueParsed = Double.parseDouble(value);
                    } else {
                        throw new RemotingCommandException("the custom field <" + fieldName + "> type is not supported");
                    }
                    field.set(objectHeader, valueParsed);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            objectHeader.checkFields();
        }
        return objectHeader;
    }

    private byte[] headerEncode() {
        this.makeCustomHeaderToNet();
        if (SerializeType.ROCKETMQ == this.serializeTypeCurrentRPC) {
            return RocketMQSerializable.rocketMQProtocolEncode(this);
        }
        return RemotingSerializable.encode(this);
    }

    private static RemotingCommand headerDecode(byte[] headerData, SerializeType type) {
        switch (type) {
            case JSON: {
                RemotingCommand resultJson = RemotingSerializable.decode(headerData, RemotingCommand.class);
                resultJson.setSerializeTypeCurrentRPC(type);
                return resultJson;
            }
            case ROCKETMQ: {
                RemotingCommand resultRMQ = RocketMQSerializable.rocketMQProtocolDecode(headerData);
                resultRMQ.setSerializeTypeCurrentRPC(type);
                return resultRMQ;
            }
        }
        return null;
    }

    public ByteBuffer encode() {
        int length = 4;
        byte[] headerData = this.headerEncode();
        length += headerData.length;
        if (this.body != null) {
            length += this.body.length;
        }
        ByteBuffer result = ByteBuffer.allocate(4 + length);
        result.putInt(length);
        result.put(RemotingCommand.markProtocolType(headerData.length, this.serializeTypeCurrentRPC));
        result.put(headerData);
        if (this.body != null) {
            result.put(this.body);
        }
        result.flip();
        return result;
    }

    public ByteBuffer encodeHeader() {
        return this.encodeHeader(this.body != null ? this.body.length : 0);
    }

    public ByteBuffer encodeHeader(int bodyLength) {
        int length = 4;
        byte[] headerData = this.headerEncode();
        length += headerData.length;
        ByteBuffer result = ByteBuffer.allocate(4 + (length += bodyLength) - bodyLength);
        result.putInt(length);
        result.put(RemotingCommand.markProtocolType(headerData.length, this.serializeTypeCurrentRPC));
        result.put(headerData);
        result.flip();
        return result;
    }

    public static RemotingCommand decode(byte[] array) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        return RemotingCommand.decode(byteBuffer);
    }

    public static RemotingCommand decode(ByteBuffer byteBuffer) {
        int length = byteBuffer.limit();
        int oriHeaderLen = byteBuffer.getInt();
        int headerLength = RemotingCommand.getHeaderLength(oriHeaderLen);
        byte[] headerData = new byte[headerLength];
        byteBuffer.get(headerData);
        RemotingCommand cmd = RemotingCommand.headerDecode(headerData, RemotingCommand.getProtocolType(oriHeaderLen));
        int bodyLength = length - 4 - headerLength;
        byte[] bodyData = null;
        if (bodyLength > 0) {
            bodyData = new byte[bodyLength];
            byteBuffer.get(bodyData);
        }
        cmd.body = bodyData;
        return cmd;
    }

    public static byte[] markProtocolType(int source, SerializeType type) {
        byte[] result = new byte[]{type.getCode(), (byte)(source >> 16 & 0xFF), (byte)(source >> 8 & 0xFF), (byte)(source & 0xFF)};
        return result;
    }

    public static SerializeType getProtocolType(int source) {
        return SerializeType.valueOf((byte)(source >> 24 & 0xFF));
    }

    public static int getHeaderLength(int length) {
        return length & 0xFFFFFF;
    }

    public void markResponseType() {
        int bits = 1;
        this.flag |= bits;
    }

    @JSONField(serialize=false)
    public boolean isResponseType() {
        int bits = 1;
        return (this.flag & bits) == bits;
    }

    public void markOnewayRPC() {
        int bits = 2;
        this.flag |= bits;
    }

    @JSONField(serialize=false)
    public boolean isOnewayRPC() {
        int bits = 2;
        return (this.flag & bits) == bits;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @JSONField(serialize=false)
    public RemotingCommandType getType() {
        if (this.isResponseType()) {
            return RemotingCommandType.RESPONSE_COMMAND;
        }
        return RemotingCommandType.REQUEST_COMMAND;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode language) {
        this.language = language;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setOpaque(int opaque) {
        this.opaque = opaque;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public HashMap<String, String> getExtFields() {
        return this.extFields;
    }

    public void setExtFields(HashMap<String, String> extFields) {
        this.extFields = extFields;
    }

    public static int createNewRequestId() {
        return RequestId.incrementAndGet();
    }

    public void addExtField(String key, String value) {
        if (null == this.extFields) {
            this.extFields = new HashMap();
        }
        this.extFields.put(key, value);
    }

    public static SerializeType getSerializeTypeConfigInThisServer() {
        return SerializeTypeConfigInThisServer;
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "RemotingCommand [code=" + this.code + ", language=" + (Object)((Object)this.language) + ", version=" + this.version + ", opaque=" + this.opaque + ", flag(B)=" + Integer.toBinaryString(this.flag) + ", remark=" + this.remark + ", extFields=" + this.extFields + ", serializeTypeCurrentRPC=" + (Object)((Object)this.serializeTypeCurrentRPC) + "]";
    }

    public SerializeType getSerializeTypeCurrentRPC() {
        return this.serializeTypeCurrentRPC;
    }

    public void setSerializeTypeCurrentRPC(SerializeType serializeTypeCurrentRPC) {
        this.serializeTypeCurrentRPC = serializeTypeCurrentRPC;
    }

    static {
        String protocol = System.getProperty(SERIALIZE_TYPE_PROPERTY, System.getenv(SERIALIZE_TYPE_ENV));
        if (!RemotingCommand.isBlank(protocol)) {
            try {
                SerializeTypeConfigInThisServer = SerializeType.valueOf(protocol);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("parser specified protocol error. protocol=" + protocol, e);
            }
        }
        StringCanonicalName = String.class.getCanonicalName();
        DoubleCanonicalName1 = Double.class.getCanonicalName();
        DoubleCanonicalName2 = Double.TYPE.getCanonicalName();
        IntegerCanonicalName1 = Integer.class.getCanonicalName();
        IntegerCanonicalName2 = Integer.TYPE.getCanonicalName();
        LongCanonicalName1 = Long.class.getCanonicalName();
        LongCanonicalName2 = Long.TYPE.getCanonicalName();
        BooleanCanonicalName1 = Boolean.class.getCanonicalName();
        BooleanCanonicalName2 = Boolean.TYPE.getCanonicalName();
    }
}

