/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.domain.vo;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.tools.ItemCornerTagUtils;
import com.google.common.base.Optional;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class ItemOpenVO
implements Serializable {
    private static final long serialVersionUID = -2274527244857763304L;
    private String logo;
    private String image;
    private String title;
    private String subtitle;
    private String credits;
    private String tagClasses;
    private String tagColor;
    private String tagText;
    private String recommendText;
    private String link;
    private String salePrice;
    private Long id;
    private String type;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(String salePrice) {
        this.salePrice = salePrice;
    }

    public ItemOpenVO(ItemKeyVO ikv, String spm) {
        this.logo = ikv.getLogo();
        this.title = ikv.getTitle();
        this.subtitle = ikv.getSubtitle();
        this.tagText = "";
        this.id = ikv.getId();
        this.type = ikv.getType();
        ItemKey items = ikv.getItemKey();
        boolean owner = true;
        if (items.isSelfAppItemMode() && items.getAppItem().getSourceType() == 5 && items.getAppItem().getSourceType() == 6) {
            owner = false;
        }
        StringBuffer sb = new StringBuffer();
        if (owner && items.getAppItem() != null && !StringUtils.isBlank((String)items.getAppItem().getCustomTag())) {
            this.recommendText = "\u5151\u6362";
            this.tagText = ItemCornerTagUtils.getCustomTagText((Optional<AppItemDO>)Optional.of((Object)items.getAppItem()));
            this.tagColor = ItemCornerTagUtils.getCustomTagColor((Optional<AppItemDO>)Optional.of((Object)items.getAppItem()));
            sb.append("custom ");
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_NORMAL) {
            this.recommendText = "\u5151\u6362";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_TIME) {
            sb.append("timelimit ");
            this.tagText = "\u79d2\u6740";
            this.tagColor = "#fe950b";
            this.recommendText = "\u5151\u6362";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_LOTTERY) {
            sb.append("turntable ");
            this.tagText = "\u62bd\u5956";
            this.tagColor = "#f43632";
            this.recommendText = "\u62bd\u5956";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_GAME) {
            sb.append("turntable ");
            this.tagText = "\u6e38\u620f";
            this.tagColor = "#f43632";
            this.recommendText = "\u6e38\u620f";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_NGAME) {
            sb.append("turntable ");
            this.tagText = "\u6e38\u620f";
            this.tagColor = "#f43632";
            this.recommendText = "\u6e38\u620f";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_QUESTION) {
            sb.append("turntable ");
            this.tagText = "\u7b54\u9898";
            this.tagColor = "#f43632";
            this.recommendText = "\u7b54\u9898";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_QUIZZ) {
            sb.append("turntable");
            this.tagText = "\u6d3b\u52a8";
            this.tagColor = "#f43632";
            this.recommendText = "\u6d3b\u52a8";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_GUESS) {
            sb.append("turntable");
            this.tagText = "\u7ade\u731c";
            this.tagColor = "#f43632";
            this.recommendText = "\u7ade\u731c";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_NEW) {
            sb.append("new ");
            this.tagText = "NEW";
            this.tagColor = "#ea0d08";
            if ("fake".equals(items.getItemType()) && items.getAppItem() != null && "gameLottery".equals(items.getAppItem().getSourceType())) {
                this.recommendText = "\u6e38\u620f";
            }
            if ("fake".equals(items.getItemType()) && items.getAppItem() != null && "ngameLottery".equals(items.getAppItem().getSourceType())) {
                this.recommendText = "\u6e38\u620f";
            }
            if ("fake".equals(items.getItemType()) && items.getAppItem() != null && "questionLottery".equals(items.getAppItem().getSourceType())) {
                this.recommendText = "\u7b54\u9898";
            }
            if ("fake".equals(items.getItemType()) && items.getAppItem() != null && "guessLottery".equals(items.getAppItem().getSourceType())) {
                this.recommendText = "\u7ade\u731c";
            }
            this.recommendText = "fake".equals(items.getItemType()) && items.getAppItem() != null && "quizzLottery".equals(items.getAppItem().getSourceType()) ? "\u6d3b\u52a8" : ("fake".equals(items.getItemType()) ? "\u62bd\u5956" : "\u5151\u6362");
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_ACTIVITY) {
            sb.append("activity ");
            this.tagText = "\u6d3b\u52a8";
            this.tagColor = "#32c59b";
            this.recommendText = "\u62bd\u5956";
        } else if (ikv.getMarkStatus() == ItemKeyVO.MARK_CREDIT_GAME) {
            sb.append("activity ");
            this.tagText = "\u79ef\u5206\u6e38\u620f";
            this.tagColor = "#f43632";
            this.recommendText = "\u79ef\u5206\u6e38\u620f";
        }
        if (ikv.getUseStatus() == ItemKeyVO.STATUS_USED) {
            sb.append("hasexchanged ");
            this.tagText = "\u5df2\u5151";
            this.tagColor = "#aaa";
            this.recommendText = "\u5df2\u5151";
        } else if (ikv.getUseStatus() == ItemKeyVO.STATUS_NOREMAING) {
            sb.append("outofstock ");
            this.tagText = "\u5151\u5b8c";
            this.tagColor = "#aaa";
            this.recommendText = "\u5151\u5b8c";
        }
        this.tagClasses = sb.toString().trim();
        String link = ikv.getLink();
        link = link.contains("?") ? (link.contains("dbnewopen") ? link.replace("dbnewopen", "spm=" + spm + "&dbnewopen") : String.valueOf(link) + "&spm=" + spm) : String.valueOf(link) + "?spm=" + spm;
        this.link = link;
    }

    public ItemOpenVO() {
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getCredits() {
        return this.credits;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    public String getTagClasses() {
        return this.tagClasses;
    }

    public void setTagClasses(String tagClasses) {
        this.tagClasses = tagClasses;
    }

    public String getRecommendText() {
        return this.recommendText;
    }

    public void setRecommendText(String recommendText) {
        this.recommendText = recommendText;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getTagText() {
        return this.tagText;
    }

    public void setTagText(String tagText) {
        this.tagText = tagText;
    }

    public String getTagColor() {
        return this.tagColor;
    }

    public void setTagColor(String tagColor) {
        this.tagColor = tagColor;
    }
}

