/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashMap<K, V> {
    public static final int DEFAULT_TABLE_SIZE = 1024;
    private final Entry<K, V>[] buckets;
    private final int indexMask;

    public IdentityHashMap() {
        this(1024);
    }

    public IdentityHashMap(int tableSize) {
        this.indexMask = tableSize - 1;
        this.buckets = new Entry[tableSize];
    }

    public final V get(K key) {
        int hash = System.identityHashCode(key);
        int bucket = hash & this.indexMask;
        Entry<K, V> entry = this.buckets[bucket];
        while (entry != null) {
            if (key == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean put(K key, V value) {
        int hash = System.identityHashCode(key);
        int bucket = hash & this.indexMask;
        Entry<K, V> entry = this.buckets[bucket];
        while (entry != null) {
            if (key == entry.key) {
                entry.value = value;
                return true;
            }
            entry = entry.next;
        }
        this.buckets[bucket] = entry = new Entry<K, V>(key, value, hash, this.buckets[bucket]);
        return false;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry<K, V> entry = this.buckets[i];
            while (entry != null) {
                ++size;
                entry = entry.next;
            }
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Entry<K, V> {
        public final int hashCode;
        public final K key;
        public V value;
        public final Entry<K, V> next;

        public Entry(K key, V value, int hash, Entry<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
            this.hashCode = hash;
        }
    }
}

