/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.support.JmxUtils;

@Configuration
@AutoConfigureBefore(value={XADataSourceAutoConfiguration.class, DataSourceAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@ConditionalOnProperty(prefix="spring.datasource", name={"jndi-name"})
@EnableConfigurationProperties(value={DataSourceProperties.class})
public class JndiDataSourceAutoConfiguration {
    @Autowired(required=false)
    private MBeanExporter mbeanExporter;

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean
    public DataSource dataSource(DataSourceProperties properties) {
        JndiDataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
        DataSource dataSource = dataSourceLookup.getDataSource(properties.getJndiName());
        this.excludeMBeanIfNecessary(dataSource, "dataSource");
        return dataSource;
    }

    private void excludeMBeanIfNecessary(Object candidate, String beanName) {
        if (this.mbeanExporter != null && JmxUtils.isMBean(candidate.getClass())) {
            this.mbeanExporter.addExcludedBean(beanName);
        }
    }
}

