/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.VerbosityCommand;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextVerbosityCommand
extends VerbosityCommand {
    public static final String VERBOSITY = "verbosity";

    public TextVerbosityCommand(CountDownLatch latch, int level, boolean noreply) {
        super(latch, level, noreply);
    }

    public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return false;
        }
        if (this.result == null) {
            byte first = buffer.get(buffer.position());
            if (first == 79) {
                this.setResult(Boolean.TRUE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, 4);
            }
            return this.decodeError(session, buffer);
        }
        return ByteUtils.stepBuffer(buffer, 4);
    }

    public void encode() {
        byte[] levelBytes = ByteUtils.getBytes(String.valueOf(this.level));
        if (this.isNoreply()) {
            this.ioBuffer = IoBuffer.allocate(4 + VERBOSITY.length() + levelBytes.length + Constants.NO_REPLY.length);
            ByteUtils.setArguments(this.ioBuffer, VERBOSITY, levelBytes, Constants.NO_REPLY);
        } else {
            this.ioBuffer = IoBuffer.allocate(3 + VERBOSITY.length() + levelBytes.length);
            ByteUtils.setArguments(this.ioBuffer, VERBOSITY, levelBytes);
        }
        this.ioBuffer.flip();
    }
}

