/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link;

import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pool<T> {
    private int maxSize;
    private int waitTimeout;
    private LinkedList<T> unused = new LinkedList();
    private LinkedList<T> used = new LinkedList();
    private Object waiter = new Object();

    public Pool() {
        this(0, 0);
    }

    public Pool(int maxSize, int waitTimeout) {
        this.maxSize = maxSize;
        this.waitTimeout = waitTimeout;
    }

    public int size() {
        return this.used.size() + this.unused.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T chekOut() throws Throwable {
        T t = this.get();
        if (t != null) {
            return t;
        }
        if (this.maxSize < 1 || this.size() < this.maxSize) {
            return this.createNew();
        }
        int i = 0;
        while (this.waitTimeout > 0 && i++ < this.waitTimeout) {
            Object object = this.waiter;
            synchronized (object) {
                try {
                    this.waiter.wait(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            t = this.get();
            if (t == null) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkIn(T t) {
        if (t == null) {
            return;
        }
        this.used.remove(t);
        this.unused.addLast(t);
        Object object = this.waiter;
        synchronized (object) {
            this.waiter.notifyAll();
        }
    }

    public abstract T create() throws Throwable;

    public abstract boolean validate(T var1);

    private synchronized T get() {
        while (!this.unused.isEmpty()) {
            T t = this.unused.removeFirst();
            if (t == null || !this.validate(t)) continue;
            this.used.add(t);
            return t;
        }
        return null;
    }

    private T createNew() throws Throwable {
        T t = this.create();
        this.used.addLast(t);
        return t;
    }
}

