/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.parser.JAXBResultParser;
import com.aliyun.oss.common.parser.ResultParseException;
import com.aliyun.oss.common.utils.ResourceManager;
import com.aliyun.oss.internal.OSSExceptionFactory;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.model.OSSErrorResult;

public class OSSErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage responseData) throws OSSException, ClientException {
        assert (responseData != null);
        if (responseData.isSuccessful()) {
            return;
        }
        String reqId = responseData.getRequestId();
        if (responseData.getContent() == null) {
            throw OSSExceptionFactory.createInvalidResponseException(reqId, ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        JAXBResultParser d = new JAXBResultParser(OSSErrorResult.class);
        try {
            try {
                OSSErrorResult err = (OSSErrorResult)d.getObject(responseData);
                throw OSSExceptionFactory.create(err);
            }
            catch (ResultParseException e) {
                throw OSSExceptionFactory.createInvalidResponseException(reqId, ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), e);
            }
        }
        catch (Throwable throwable) {
            OSSUtils.safeCloseResponse(responseData);
            throw throwable;
        }
    }
}

