/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.tool;

import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestTool {
    private static String localHostIp;
    private static ThreadLocal<HttpServletRequest> request;
    private static String unknownStr;
    private RequestTool rqt;

    public RequestTool getRequestTool() {
        if (this.rqt == null) {
            this.rqt = new RequestTool();
        }
        return this.rqt;
    }

    public static String getLocalHostIp() {
        return localHostIp;
    }

    public static void setLocalHostIp(String localHostIp) {
        RequestTool.localHostIp = localHostIp;
    }

    public static HttpServletRequest getHttpServletRequest() {
        return request.get();
    }

    public static void setRequestInThreadLocal(HttpServletRequest req) {
        request.set(req);
    }

    public static String getRequestIpInThreadLocal() {
        HttpServletRequest req = request.get();
        if (req != null) {
            return RequestTool.getIpAddr(req);
        }
        return null;
    }

    public static String getRequestUAInThreadLocal() {
        HttpServletRequest req = request.get();
        if (req != null) {
            return req.getHeader("User-Agent");
        }
        return null;
    }

    public static String getNewRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return url;
        }
        return url + "?" + queryString;
    }

    public static String getRequestUrl(HttpServletRequest request) {
        String path;
        String queryString = request.getQueryString();
        queryString = queryString == null ? "" : "?" + queryString;
        if ("post".equalsIgnoreCase(request.getMethod())) {
            queryString = "?" + queryString;
            Map map = request.getParameterMap();
            for (String key : map.keySet()) {
                if (((String[])map.get(key)).length <= 0) continue;
                queryString = queryString + key + "=" + ((String[])map.get(key))[0] + "&";
            }
        }
        if ((path = (String)request.getAttribute("javax.servlet.forward.request_uri")) != null) {
            return "http://" + request.getServerName() + ":" + request.getServerPort() + path + queryString;
        }
        return request.getRequestURL().toString();
    }

    public static String getIpAddr(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[size - 1].trim();
        }
        if (ip == null || ip.length() == 0 || unknownStr.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || unknownStr.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || unknownStr.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || unknownStr.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || unknownStr.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = localHostIp;
        }
        return ip;
    }

    public static String getOS(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (ua == null) {
            return "Unkonwn";
        }
        if ((ua = ua.toLowerCase()) != null) {
            if (ua.contains("ipad")) {
                return "iPad";
            }
            if (ua.contains("iphone")) {
                return "iPhone";
            }
            if (ua.contains("android")) {
                return "Android";
            }
            if (ua.contains("linux")) {
                return "Linux";
            }
            if (ua.contains("windows")) {
                return "Windows";
            }
            if (ua.contains("macintosh")) {
                return "Mac";
            }
        }
        return "Unknown";
    }

    public static boolean isLocalRequest(HttpServletRequest request) {
        String ip = RequestTool.getIpAddr(request);
        return ip.startsWith(localHostIp) || ip.startsWith("0:0:0:0");
    }

    public static boolean isHttpsRequest(HttpServletRequest request) {
        return "true".equals(request.getHeader("Use-Https"));
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                String value;
                Cookie c = cookies[i];
                if (!name.equals(c.getName()) || (value = c.getValue()) == null || value.length() <= 0) continue;
                return value;
            }
        }
        return null;
    }

    public static String getServerPath(HttpServletRequest request) {
        String port = String.valueOf(request.getServerPort());
        port = "80".equals(port) ? "" : ":" + port;
        return request.getScheme() + "://" + request.getServerName() + port;
    }

    static {
        request = new ThreadLocal();
        unknownStr = "unknown";
    }
}

