/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.utils.ResultUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler
    public <T> Result<T> failResult(Exception e) {
        if (e instanceof TuiaMediaException) {
            TuiaMediaException e1 = (TuiaMediaException)e;
            this.logger.error("\u53d1\u751f\u5185\u90e8\u9519\u8bef, because of=[{}]", (Object)e1.getResultMessage());
            return ResultUtil.fail((String)e1.getResultCode(), (String)e1.getResultMessage());
        }
        this.logger.error("\u53d1\u751f\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
        return ResultUtil.fail((ErrorCode)ErrorCode.E9999999);
    }

    protected <T> void doTuiaCoreException(DubboResult<T> result, String callInterface) throws TuiaMediaException {
        if (!result.isResultSuccess()) {
            String returnCode = result.getReturnCode();
            String msg = result.getMsg();
            this.logger.error("[TuiaCore] " + callInterface + " failed, because of=[{}] and the returnCode=[{}]", (Object)result.getMsg(), (Object)returnCode);
            if (returnCode.endsWith("9999999")) {
                msg = "\u53d1\u751f\u672a\u77e5\u9519\u8bef";
                returnCode = "9999999";
            }
            throw new TuiaMediaException(returnCode, msg);
        }
    }

    public <T> Result<T> successResult(T t) {
        return ResultUtil.success(t);
    }

    public <T> Result<T> successResult() {
        return ResultUtil.success();
    }

    public void checkParam(BindingResult result) throws TuiaMediaException {
        if (result.hasErrors()) {
            this.logger.error("[param] error, because of " + result.getFieldError());
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), result.getFieldError().getDefaultMessage());
        }
    }
}

