/**
 * 
 */
package cn.com.duiba.tuia.media.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.IDGeneratorTool;
import cn.com.duiba.tuia.media.common.tool.UploadTool;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.rsp.UploadRsp;

/**
 * @author Sunjiangrong
 */
@Controller
@RequestMapping("/upload")
@Api("文件上传api")
public class UploadController extends BaseController {

    /**
     * upload:(上传营业照). <br/>
     *
     * @author ZFZ
     * @param request
     * @param response
     * @return
     * @since JDK 1.6
     */
    @ApiOperation(value = "上传营业照", httpMethod = "POST", notes = "上传营业照接口")
    @ResponseBody
    @RequestMapping(value = "/index", method = RequestMethod.POST)
    public Result<UploadRsp> upload(HttpServletRequest request, HttpServletResponse response) {
        try {
            doCheckRequestType(request);
            
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
            MultipartFile mf = multipartRequest.getFile("file");
            if (mf == null) {
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            String fileName = mf.getOriginalFilename();
            String fileType = fileName.substring(fileName.lastIndexOf('.') + 1);
            if ("jpg".equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType) || "png".equalsIgnoreCase(fileType) || "gif".equalsIgnoreCase(fileType)) {
                UploadRsp rsp = doSetFilePath(mf, fileName, fileType);
                return successResult(rsp);
            } else {
                // 文件类型不符
                logger.error("not supported [{}] file type", fileType);
                throw new TuiaMediaException(ErrorCode.E0002005);
            }
        } catch (Exception e) {
            logger.error("upload error!");
            return failResult(e);
        }
    }

    /**
     * upload:(上传身份证正面照片). <br/>
     *
     * @author ZFZ
     * @param request
     * @param response
     * @return
     * @since JDK 1.6
     */
    @ApiOperation(value = "上传身份证正面照片", httpMethod = "POST", notes = "上传身份证正面照片接口")
    @ResponseBody
    @RequestMapping(value = "/UpdateIdCardFront", method = RequestMethod.POST)
    public Result<UploadRsp> UpdateIdCardFront(HttpServletRequest request, HttpServletResponse response) {
        try {
            doCheckRequestType(request);

            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;

            MultipartFile mf = multipartRequest.getFile("file");
            if (mf == null) {
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            String fileName = mf.getOriginalFilename();

            String fileType = fileName.substring(fileName.lastIndexOf('.') + 1);
            if ("jpg".equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType) || "png".equalsIgnoreCase(fileType) || "gif".equalsIgnoreCase(fileType)) {

                UploadRsp rsp = doSetFilePath(mf, fileName, fileType);

                return successResult(rsp);
            } else {
                // 文件类型不符
                logger.error("not supported [{}] file type", fileType);
                throw new TuiaMediaException(ErrorCode.E0002005);
            }
        } catch (Exception e) {
            logger.error("upload error!");
            return failResult(e);
        }
    }

    private UploadRsp doSetFilePath(MultipartFile mf, String fileName, String fileType) throws IOException, TuiaMediaException {
        String name = IDGeneratorTool.getRandomString(10) + "." + fileType;
        String path = "tuia-media/img/" + name;
        long size = mf.getSize();
        InputStream inputStream = mf.getInputStream();
        UploadTool.uploadOssImg(inputStream, path, size);
        UploadRsp rsp = new UploadRsp();
        rsp.setFileName(fileName);
        rsp.setUrl(UploadTool.getTuiaUrl() + path);
        return rsp;
    }

    private void doCheckRequestType(HttpServletRequest request) throws TuiaMediaException {
        // 解析器解析request的上下文
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        // 先判断request中是否包涵multipart类型的数据，
        if (!multipartResolver.isMultipart(request)) {
            throw new TuiaMediaException(ErrorCode.E9999999);
        }
    }
}
