/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.bo.AccountBackendBO;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.BlowfishUtils;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.req.ReqEmailToken;
import cn.com.duiba.tuia.media.model.req.ReqLogin;
import cn.com.duiba.tuia.media.model.req.ReqRegister;
import cn.com.duiba.tuia.media.model.req.ReqResetPassword;
import cn.com.duiba.tuia.media.model.req.ReqSendEmail;
import cn.com.duiba.tuia.media.model.req.ReqSendSMS;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBase;
import cn.com.duiba.tuia.media.model.req.ReqUpdateCompanyInfo;
import cn.com.duiba.tuia.media.model.req.ReqUpdatePersonInfo;
import cn.com.duiba.tuia.media.model.req.ReqUpdateVerifyInfo;
import cn.com.duiba.tuia.media.model.req.ReqVerifyCode;
import cn.com.duiba.tuia.media.model.rsp.AccountInfoRsp;
import cn.com.duiba.tuia.media.model.rsp.RegisterRsp;
import cn.com.duiba.tuia.media.model.rsp.TokenRsp;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.SmsService;
import cn.com.duiba.tuia.media.utils.CookieUtil;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.aop.LogWrite;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/account"})
@Api(value="\u8d26\u6237\u76f8\u5173api")
public class AccountController
extends BaseController {
    @Value(value="${media.consumer.encrypt.key}")
    private String consumerEncryptKey;
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountBackendBO accountBackendBO;
    @Autowired
    private SmsService smsService;
    private static final int REPLACE_PHONE_NUM = 2;

    @ApiOperation(value="\u5a92\u4f53\u8d26\u53f7\u662f\u5426\u88ab\u5360\u7528", httpMethod="GET", notes="\u5a92\u4f53\u8d26\u53f7\u662f\u5426\u88ab\u5360\u7528\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/isExists"}, method={RequestMethod.GET})
    public Result<Boolean> isEmailExists(@RequestParam String value) {
        try {
            if (this.accountService.isEmailExists(value)) {
                this.logger.error("email is exist, email =[{}]", (Object)value);
                throw new TuiaMediaException(ErrorCode.E0102011);
            }
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.isEmialExists error!,the param=[{}]", (Object)value);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u6ce8\u518c\u65f6\u624b\u673a\u53f7\u662f\u5426\u88ab\u5360\u7528", httpMethod="GET", notes="\u6ce8\u518c\u65f6\u624b\u673a\u53f7\u662f\u5426\u88ab\u5360\u7528\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="value", value="\u624b\u673a\u53f7", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="mediaId", value="\u5a92\u4f53\u8d26\u6237ID", required=false, dataType="Long", paramType="query")})
    @ResponseBody
    @RequestMapping(value={"/isExistPhone"}, method={RequestMethod.GET})
    public Result<Boolean> isExistPhone(@RequestParam String value, @RequestParam(required=false) Long mediaId) {
        try {
            if (this.accountService.repeatRegisterVerifyPhone(value, null)) {
                this.logger.error("linkPhone is exist, linkPhone =[{}]", (Object)value);
                throw new TuiaMediaException(ErrorCode.E0102021);
            }
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.isExistPhone error!,the param=[{}]", (Object)value);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u6ce8\u518c", ignoreParams={"passwd"})
    @ApiOperation(value="\u5a92\u4f53\u8d26\u53f7\u6ce8\u518c", httpMethod="POST", notes="\u5a92\u4f53\u8d26\u53f7\u6ce8\u518c\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    public Result<RegisterRsp> register(@Valid @RequestBody ReqRegister req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountBackendBO.register(req));
        }
        catch (Exception e) {
            this.logger.error("AccountController.register error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u6ce8\u518c\u90ae\u4ef6\u9a8c\u8bc1", httpMethod="GET", notes="\u6ce8\u518c\u90ae\u4ef6\u9a8c\u8bc1\u63a5\u53e3")
    @RequestMapping(value={"/verifyEmail"}, method={RequestMethod.GET})
    public String verifyEmail(@Valid @ModelAttribute ReqEmailToken req, BindingResult result) {
        try {
            this.checkParam(result);
            this.accountService.verifyEmail(req.getToken());
            return "redirect:/#/verified?email=" + req.getEmail();
        }
        catch (Exception e) {
            this.logger.error("verifyEmail error!,the param = [{}] and the msg = [{}]", (Object)req, (Object)e);
            return "redirect:/#/expired?email=" + req.getEmail();
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u90ae\u4ef6", httpMethod="POST", notes="\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u90ae\u4ef6\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/repeatVerifyEmail"}, method={RequestMethod.POST})
    public Result<Boolean> repeatVerifyEmail(@Valid @RequestBody ReqSendEmail req, BindingResult result) {
        try {
            this.checkParam(result);
            this.accountService.repeatVerifyEmail(req.getEmail());
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.repeatVerifyEmail error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u767b\u5f55", ignoreParams={"password"})
    @ApiOperation(value="\u5a92\u4f53\u8d26\u53f7\u767b\u5f55", httpMethod="POST", notes="\u5a92\u4f53\u8d26\u53f7\u767b\u5f55\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<Boolean> login(@Valid @RequestBody ReqLogin reqLogin, BindingResult result) {
        try {
            this.checkParam(result);
            this.buildLoginCookie(this.accountBackendBO.login(reqLogin.getEmail(), reqLogin.getPassword()));
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.login error!,the param=[{}]", (Object)reqLogin);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u90ae\u4ef6", httpMethod="POST", notes="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u90ae\u4ef6\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/sendResetPdEmail"}, method={RequestMethod.POST})
    public Result<Boolean> sendResetPdEmail(@Valid @RequestBody ReqSendEmail req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountService.sendResetPasswdEmail(req.getEmail()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.sendResetPdEmail error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u53d1\u9001\u66f4\u6362\u90ae\u7bb1\u9a8c\u8bc1\u7801\u90ae\u4ef6", httpMethod="POST", notes="\u53d1\u9001\u66f4\u6362\u90ae\u7bb1\u9a8c\u8bc1\u7801\u90ae\u4ef6\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/sendReplaceEmail"}, method={RequestMethod.POST})
    public Result<Boolean> sendReplaceEmail(@Valid @RequestBody ReqSendEmail req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountService.sendReplaceEmail(req.getEmail(), RequestLocal.get().getCid()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.sendReplaceEmail error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u6821\u9a8c", httpMethod="POST", notes="\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u6821\u9a8c\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/verifyResetPdCode"}, method={RequestMethod.POST})
    public Result<TokenRsp> verifyResetPdCode(@Valid @RequestBody ReqVerifyCode req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountService.resetPasswdRedirect(req.getEmail(), req.getVerificationCode()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.verifyResetPdCode error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u91cd\u7f6e\u5bc6\u7801", ignoreParams={"newPassword"})
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801", httpMethod="POST", notes="\u91cd\u7f6e\u5bc6\u7801\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.POST})
    public Result<Boolean> resetPassword(@Valid @RequestBody ReqResetPassword req, BindingResult result) {
        try {
            this.checkParam(result);
            boolean flag = this.accountService.resetPassword(req.getEmail(), req.getNewPassword(), req.getToken());
            CookieUtil.deleteCookie((String)"dataxyz345");
            return this.successResult(flag);
        }
        catch (Exception e) {
            this.logger.error("AccountController.resetPasswd error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u7528\u6237\u8be6\u60c5\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/getAccountInfo"}, method={RequestMethod.GET})
    public Result<AccountInfoRsp> getAccountInfo() {
        try {
            Long mediaId = RequestLocal.get().getCid();
            return this.successResult(this.accountBackendBO.getAccountInfo(mediaId));
        }
        catch (Exception e) {
            this.logger.error("AccountController.getAccountInfo error!");
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f")
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f", httpMethod="POST", notes="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/updateAccountBase"}, method={RequestMethod.POST})
    public Result<Boolean> updateAccountBase(@Valid @RequestBody ReqUpdateAccountBase req, BindingResult result) {
        try {
            this.checkParam(result);
            req.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.accountService.updateAccountBase(req));
        }
        catch (Exception e) {
            this.logger.error("AccountController.updateAccountBase error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u5a92\u4f53\u8d26\u6237\u9000\u51fa", httpMethod="POST", notes="\u5a92\u4f53\u8d26\u6237\u9000\u51fa\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    public Result<Boolean> logout() {
        try {
            CookieUtil.deleteCookie((String)"dataxyz345");
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.logout error!");
            return this.failResult(e);
        }
    }

    private void buildLoginCookie(Long mediaId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("loginTime", (Object)new Date().getTime());
        jsonObject.put("accountId", (Object)mediaId);
        String envalue = BlowfishUtils.encryptBlowfish((String)jsonObject.toJSONString(), (String)this.consumerEncryptKey);
        CookieUtil.setCrossCookie((String)"dataxyz345", (String)envalue);
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u7528\u6237\u4fee\u6539\u516c\u53f8\u4fe1\u606f")
    @ApiOperation(value="\u7528\u6237\u4fee\u6539\u516c\u53f8\u4fe1\u606f", httpMethod="POST", notes="\u7528\u6237\u4fee\u6539\u516c\u53f8\u4fe1\u606f\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/updateCompanyInfo"}, method={RequestMethod.POST})
    public Result<Boolean> updateCompanyInfo(@Valid @RequestBody ReqUpdateCompanyInfo req, BindingResult result) {
        try {
            this.checkParam(result);
            req.setMediaId(RequestLocal.get().getCid());
            this.accountService.updateCompanyInfo(req);
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.updateCompanyInfo error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u7528\u6237\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f")
    @ApiOperation(value="\u7528\u6237\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f", httpMethod="POST", notes="\u7528\u6237\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/updatePersonInfo"}, method={RequestMethod.POST})
    public Result<Boolean> updatePersonInfo(@Valid @RequestBody ReqUpdatePersonInfo req, BindingResult result) {
        try {
            this.checkParam(result);
            req.setMediaId(RequestLocal.get().getCid());
            this.accountService.updatePersonInfo(req);
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.updatePersonInfo error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801", httpMethod="POST", notes="\u53d1\u9001\u66f4\u6362\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/sendReplacePhone"}, method={RequestMethod.POST})
    public Result<Boolean> sendReplacePhone(@Valid @RequestBody ReqSendSMS req, BindingResult result) {
        try {
            this.checkParam(result);
            req.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.accountService.sendReplacePhone(req));
        }
        catch (Exception e) {
            this.logger.error("AccountController.sendReplaceEmail error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u624b\u673a\u53f7", httpMethod="POST", notes="\u4fee\u6539\u624b\u673a\u53f7\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/updatePhoneNum"}, method={RequestMethod.POST})
    public Result<Boolean> updatePhoneNum(@Valid @RequestBody ReqUpdateVerifyInfo req, BindingResult result) {
        try {
            this.checkParam(result);
            Long mediaId = RequestLocal.get().getCid();
            String linkPhone = req.getLinkPhone();
            if (StringUtils.isEmpty((String)linkPhone)) {
                this.logger.info("linkPhone is not null,the linkPhone=[{}]]", (Object)linkPhone);
                throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u7535\u8bdd\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.accountService.repeatRegisterVerifyPhone(linkPhone, mediaId)) {
                this.logger.error("linkPhone is exist, linkPhone =[{}]", (Object)linkPhone);
                throw new TuiaMediaException(ErrorCode.E0102021);
            }
            this.smsService.verify(2, linkPhone, req.getCode());
            return this.successResult(this.accountService.updatePhoneNum(mediaId, linkPhone));
        }
        catch (Exception e) {
            this.logger.error("AccountController.sendReplaceEmail error!,the req=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u90ae\u7bb1", httpMethod="POST", notes="\u4fee\u6539\u90ae\u7bb1\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/updateEmail"}, method={RequestMethod.POST})
    public Result<Boolean> updateEmail(@Valid @RequestBody ReqUpdateVerifyInfo req, BindingResult result) {
        try {
            this.checkParam(result);
            String email = req.getEmail();
            if (StringUtils.isEmpty((String)email)) {
                this.logger.info("email is not null,the email=[{}]]", (Object)email);
                throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u90ae\u7bb1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.accountService.isEmailExists(email)) {
                this.logger.error("email is exist, the email =[{}]", (Object)email);
                throw new TuiaMediaException(ErrorCode.E0102011);
            }
            return this.successResult(this.accountService.replaceEmail(req.getCode(), RequestLocal.get().getCid()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.sendReplaceEmail error!,the req=[{}]", (Object)req);
            return this.failResult(e);
        }
    }
}

