/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.ServerAddressAware;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.command.binary.ResponseStatus;
import net.rubyeye.xmemcached.exception.UnknownCommandException;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class BinaryStatsCommand
extends BaseBinaryCommand
implements ServerAddressAware {
    private InetSocketAddress server;
    private String itemName;
    private String currentResponseItem;

    public String getItemName() {
        return this.itemName;
    }

    public final InetSocketAddress getServer() {
        return this.server;
    }

    public final void setServer(InetSocketAddress server) {
        this.server = server;
    }

    public void setItemName(String item) {
        this.itemName = item;
    }

    public BinaryStatsCommand(InetSocketAddress server, CountDownLatch latch, String itemName) {
        super(null, null, CommandType.STATS, latch, 0, 0L, null, false, null);
        this.server = server;
        this.itemName = itemName;
        this.opCode = OpCode.STAT;
        this.result = new HashMap();
    }

    protected boolean finish() {
        if (this.currentResponseItem == null) {
            return super.finish();
        }
        this.currentResponseItem = null;
        return false;
    }

    protected void readStatus(ByteBuffer buffer) {
        ResponseStatus responseStatus = ResponseStatus.parseShort(buffer.getShort());
        if (responseStatus == ResponseStatus.UNKNOWN_COMMAND) {
            this.setException(new UnknownCommandException());
        }
    }

    protected boolean readKey(ByteBuffer buffer, int keyLength) {
        if (buffer.remaining() < keyLength) {
            return false;
        }
        if (keyLength > 0) {
            byte[] bytes = new byte[keyLength];
            buffer.get(bytes);
            this.currentResponseItem = new String(bytes);
        }
        return true;
    }

    protected boolean readValue(ByteBuffer buffer, int bodyLength, int keyLength, int extrasLength) {
        int valueLength = bodyLength - keyLength - extrasLength;
        if (buffer.remaining() < valueLength) {
            return false;
        }
        if (valueLength > 0) {
            byte[] bytes = new byte[valueLength];
            buffer.get(bytes);
            String value = new String(bytes);
            ((Map)this.result).put(this.currentResponseItem, value);
        }
        return true;
    }

    protected void fillExtras(CachedData data) {
    }

    protected void fillValue(CachedData data) {
    }

    protected byte getExtrasLength() {
        return 0;
    }

    protected int getValueLength(CachedData data) {
        return 0;
    }

    protected void fillKey() {
        if (this.itemName != null) {
            byte[] keyBytes = ByteUtils.getBytes(this.itemName);
            this.ioBuffer.put(keyBytes);
        }
    }

    protected int getKeyLength() {
        if (this.itemName != null) {
            return this.itemName.length();
        }
        return 0;
    }
}

