/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.AlipayMicropayOrderDirectPayResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlipayMicropayOrderDirectPayRequest
implements TaobaoRequest<AlipayMicropayOrderDirectPayResponse> {
    private Map<String, String> headerMap = new TaobaoHashMap();
    private TaobaoHashMap udfParams;
    private Long timestamp;
    private String alipayOrderNo;
    private String amount;
    private String authToken;
    private String memo;
    private String receiveUserId;
    private String transferOutOrderNo;

    public void setAlipayOrderNo(String alipayOrderNo) {
        this.alipayOrderNo = alipayOrderNo;
    }

    public String getAlipayOrderNo() {
        return this.alipayOrderNo;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setReceiveUserId(String receiveUserId) {
        this.receiveUserId = receiveUserId;
    }

    public String getReceiveUserId() {
        return this.receiveUserId;
    }

    public void setTransferOutOrderNo(String transferOutOrderNo) {
        this.transferOutOrderNo = transferOutOrderNo;
    }

    public String getTransferOutOrderNo() {
        return this.transferOutOrderNo;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getApiMethodName() {
        return "alipay.micropay.order.direct.pay";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("alipay_order_no", this.alipayOrderNo);
        txtParams.put("amount", this.amount);
        txtParams.put("auth_token", this.authToken);
        txtParams.put("memo", this.memo);
        txtParams.put("receive_user_id", this.receiveUserId);
        txtParams.put("transfer_out_order_no", this.transferOutOrderNo);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public void putOtherTextParam(String key, String value) {
        if (this.udfParams == null) {
            this.udfParams = new TaobaoHashMap();
        }
        this.udfParams.put(key, value);
    }

    @Override
    public Class<AlipayMicropayOrderDirectPayResponse> getResponseClass() {
        return AlipayMicropayOrderDirectPayResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.alipayOrderNo, "alipayOrderNo");
        RequestCheckUtils.checkNotEmpty(this.amount, "amount");
        RequestCheckUtils.checkNotEmpty(this.authToken, "authToken");
        RequestCheckUtils.checkNotEmpty(this.memo, "memo");
        RequestCheckUtils.checkNotEmpty(this.receiveUserId, "receiveUserId");
        RequestCheckUtils.checkNotEmpty(this.transferOutOrderNo, "transferOutOrderNo");
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }
}

