/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.channel.websocket;

import com.taobao.top.link.Text;
import com.taobao.top.link.channel.ChannelException;
import com.taobao.top.link.channel.ChannelSender;
import com.taobao.top.link.channel.netty.NettyChannelSender;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;

public abstract class WebSocketChannelSender
extends NettyChannelSender {
    public WebSocketChannelSender(Channel channel) {
        super(channel);
    }

    public void send(byte[] data, int offset, int length) throws ChannelException {
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(buffer);
        this.send((WebSocketFrame)frame, null, 0);
    }

    public void send(ByteBuffer dataBuffer, ChannelSender.SendHandler sendHandler) throws ChannelException {
        this.sendSync(dataBuffer, sendHandler, 0);
    }

    public boolean sendSync(ByteBuffer dataBuffer, ChannelSender.SendHandler sendHandler, int timeoutMilliseconds) throws ChannelException {
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((ByteBuffer)dataBuffer);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(buffer);
        return this.send((WebSocketFrame)frame, sendHandler, timeoutMilliseconds);
    }

    public void close(String reason) {
        this.channel.write((Object)new CloseWebSocketFrame(1000, reason));
    }

    private boolean send(WebSocketFrame frame, final ChannelSender.SendHandler sendHandler, int timeout) throws ChannelException {
        frame.setFinalFragment(true);
        final CountDownLatch latch = timeout > 0 ? new CountDownLatch(1) : null;
        this.channel.write((Object)frame).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (latch != null) {
                    latch.countDown();
                } else if (sendHandler != null) {
                    sendHandler.onSendComplete(future.isSuccess());
                }
            }
        });
        if (latch == null) {
            return true;
        }
        try {
            boolean bl = latch.await(timeout, TimeUnit.MILLISECONDS);
            return bl;
        }
        catch (InterruptedException e) {
            throw new ChannelException(Text.WS_SEND_SYNC_ERROR, e);
        }
    }
}

