/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.nio.ByteBuffer;
import javax.servlet.http.HttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.AbstractProcessor;
import org.apache.coyote.http11.upgrade.NioServletInputStream;
import org.apache.coyote.http11.upgrade.NioServletOutputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class NioProcessor
extends AbstractProcessor<NioChannel> {
    private static final Log log = LogFactory.getLog(NioProcessor.class);
    private static final int INFINITE_TIMEOUT = -1;

    @Override
    protected Log getLog() {
        return log;
    }

    public NioProcessor(SocketWrapper<NioChannel> wrapper, ByteBuffer leftoverInput, HttpUpgradeHandler httpUpgradeProcessor, NioSelectorPool pool, int asyncWriteBufferSize) {
        super(httpUpgradeProcessor, new NioServletInputStream(wrapper, pool), new NioServletOutputStream(wrapper, asyncWriteBufferSize, pool));
        wrapper.setTimeout(-1L);
        if (leftoverInput != null) {
            ByteBuffer readBuffer = wrapper.getSocket().getBufHandler().getReadBuffer();
            if (readBuffer.remaining() > 0) {
                readBuffer.flip();
            } else {
                readBuffer.clear();
            }
            readBuffer.put(leftoverInput);
            readBuffer.flip();
        }
    }
}

