/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.perf;

import cn.com.duiba.wolf.perf.PerfCollector;
import cn.com.duiba.wolf.perf.PerfResult;
import cn.com.duiba.wolf.perf.PerfRunable;
import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Performances {
    private int count;
    private int loop;
    private PerfRunable perfRunable;
    private final PerfCollector perfCollector = new PerfCollector();
    private ExecutorService executorService;

    public static Performances newBuilder() {
        return new Performances();
    }

    public Performances count(int count) {
        this.count = count;
        return this;
    }

    public Performances perfRunable(PerfRunable perfRunable) {
        this.perfRunable = perfRunable;
        return this;
    }

    public Performances loop(int loop) {
        this.loop = loop;
        return this;
    }

    public PerfResult start() {
        Preconditions.checkArgument((this.loop > 0 ? 1 : 0) != 0, (Object)"loop must bigger than 0");
        Preconditions.checkArgument((this.count > 0 ? 1 : 0) != 0, (Object)"count must bigger than 0");
        this.executorService = Executors.newFixedThreadPool(this.count);
        final CountDownLatch countDown = new CountDownLatch(this.loop);
        this.perfCollector.setStartTime(System.currentTimeMillis());
        for (int i = 0; i < this.loop; ++i) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < Performances.this.count; ++j) {
                        try {
                            long startTime = System.currentTimeMillis();
                            Performances.this.perfRunable.run();
                            long endTime = System.currentTimeMillis();
                            Performances.this.perfCollector.addValue(endTime - startTime);
                            Performances.this.perfCollector.addSuccess();
                            continue;
                        }
                        catch (Exception e) {
                            Performances.this.perfCollector.addFail();
                        }
                    }
                    countDown.countDown();
                }
            });
        }
        try {
            countDown.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.perfCollector.setEndTime(System.currentTimeMillis());
        PerfResult perfResult = this.perfCollector.compute();
        return perfResult;
    }
}

