/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="materialSpecificationItemContentDAO")
public class MaterialSpecificationItemContentDAOImpl
extends BaseDAO
implements MaterialSpecificationItemContentDAO {
    @Override
    public int insertBatch(List<MaterialSpecificationItemContentDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return this.getSqlSession().insert(this.getStamentNameSpace("insertBatch"), list);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.insertBatch happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int deleteBatch(List<Long> ids) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return 0;
            }
            return this.getSqlSession().delete(this.getStamentNameSpace("deleteBatch"), ids);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.deleteBatch happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int itemContentAmount(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("itemContentAmount"), map);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.hasItemContent happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<MaterialSpecificationItemContentDO> selectByActivityAndMsId(Long activityId, Integer activityType, Long msId) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            map.put("msId", msId);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectByActivityAndMsId"), map);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.selectByActivityAndMsId happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int deleteByActivityAndMsId(Long activityId, Integer activityType, Long msId) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            map.put("msId", msId);
            return this.getSqlSession().delete(this.getStamentNameSpace("deleteByActivityAndMsId"), map);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.deleteByActivityAndMsId happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<Long> selectMsIdsByActivity(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectMsIdsByActivity"), map);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.selectMsIdsByActivity happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int changeStatus(Long id) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("changeStatus"), (Object)id);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.changeStatus happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

