/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityManualPlanDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.service.ActivityManualService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityManualServiceImpl
implements ActivityManualService {
    @Autowired
    private ActivityManualPlanDAO activityManualPlanDAO;

    @Override
    public boolean addActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        List<ActivityManualPlanDO> planList = this.activityManualPlanDAO.selectForList(manualPlan.getSlotId());
        for (ActivityManualPlanDO plan : planList) {
            if (plan.getActivityId() == null || plan.getActivityType() == null || !plan.getActivityId().equals(manualPlan.getActivityId()) || !plan.getActivityType().equals(manualPlan.getActivityType())) continue;
            throw new TuiaMediaException(ErrorCode.E9999999.getErrorCode(), "\u6d3b\u52a8\u5df2\u5b58\u5728");
        }
        manualPlan.setStatus(0);
        return this.activityManualPlanDAO.insert(manualPlan);
    }

    @Override
    public boolean modifyActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        return this.activityManualPlanDAO.update(manualPlan);
    }

    @Override
    public ActivityManualPlanDO findActivityManualPlan(Long slotId) throws TuiaMediaException {
        List<ActivityManualPlanDO> planList = this.findActivityManualPlans(slotId);
        for (ActivityManualPlanDO plan : planList) {
            if (1 != plan.getStatus()) continue;
            return plan;
        }
        return null;
    }

    @Override
    public List<ActivityManualPlanDO> findActivityManualPlans(Long slotId) throws TuiaMediaException {
        ActivityManualPlanDO currentPlan = null;
        long currentTime = System.currentTimeMillis();
        List<ActivityManualPlanDO> planList = this.activityManualPlanDAO.selectForList(slotId);
        for (ActivityManualPlanDO plan : planList) {
            if (currentTime < plan.getReleaseTime().getTime()) continue;
            currentPlan = plan;
        }
        if (currentPlan != null) {
            currentPlan.setStatus(1);
            this.activityManualPlanDAO.updateStatus(currentPlan, 1);
            this.activityManualPlanDAO.updateStatusBefore(currentPlan, 2);
        }
        return this.activityManualPlanDAO.selectForList(slotId);
    }

    @Override
    public boolean removeActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        return this.activityManualPlanDAO.delete(manualPlan);
    }
}

