/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySpmDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySpmDO;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activitySpmService")
public class ActivitySpmServiceImpl
implements ActivitySpmService {
    @Autowired
    private ActivitySpmDAO activitySpmDAO;
    @Autowired
    private SlotCacheService slotCacheService;

    @Override
    public List<ActivitySpmDto> getSlotSpm(Long slotId, Integer statType) throws TuiaMediaException {
        if (1 == statType) {
            SlotCacheDto slotCacheDto = this.slotCacheService.getSlot(slotId);
            Long appId = slotCacheDto.getAppId();
            List<ActivitySpmDO> spm = this.activitySpmDAO.selectBySlot(slotId, appId, 1);
            if (!CollectionUtils.isEmpty(spm)) {
                return this.parseToDto(spm);
            }
        } else if (2 == statType) {
            List<ActivitySpmDO> spm = this.activitySpmDAO.selectBySlot(-1L, slotId, 2);
            if (!CollectionUtils.isEmpty(spm)) {
                return this.parseToDto(spm);
            }
        } else {
            List<ActivitySpmDO> spm = this.activitySpmDAO.selectBySlot(-1L, -1L, 3);
            if (!CollectionUtils.isEmpty(spm)) {
                return this.parseToDto(spm);
            }
        }
        return Collections.emptyList();
    }

    private List<ActivitySpmDto> parseToDto(List<ActivitySpmDO> list) {
        ArrayList<ActivitySpmDto> result = new ArrayList<ActivitySpmDto>();
        for (ActivitySpmDO activitySpmDO : list) {
            ActivitySpmDto activitySpmDto = new ActivitySpmDto();
            activitySpmDto.setActivityId(activitySpmDO.getActivityId());
            activitySpmDto.setActivityType(activitySpmDO.getActivityType());
            activitySpmDto.setSpm(activitySpmDO.getSpm());
            activitySpmDto.setStatType(activitySpmDO.getStatType());
            result.add(activitySpmDto);
        }
        return result;
    }
}

