/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.model.Email;
import cn.com.duiba.tuia.media.service.EmailService;
import javax.mail.internet.MimeMessage;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Service
public class EmailServiceImpl
implements EmailService {
    private Logger logger = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Value(value="${media.email.sys.user.name}")
    private String systemUserEmail;
    @Autowired
    private JavaMailSender sender;
    @Autowired
    private VelocityEngine velocityEngine;

    @Override
    public void sendWithTemplate(Email email) {
        try {
            MimeMessage mail = this.sender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mail);
            helper.setTo(email.getTo());
            helper.setSubject(email.getSubject());
            helper.setFrom(this.systemUserEmail);
            String text = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)email.getTemplateLocation(), (String)"UTF-8", email.getModel());
            helper.setText(text, email.getIsHtml().booleanValue());
            this.sender.send(mail);
        }
        catch (Exception e) {
            this.logger.error("send email failed!", (Throwable)e);
        }
    }
}

