/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.data.redis.hash.HashMapper;

public class BeanUtilsHashMapper<T>
implements HashMapper<T, String, String> {
    private Class<T> type;

    public BeanUtilsHashMapper(Class<T> type) {
        this.type = type;
    }

    @Override
    public T fromHash(Map<String, String> hash) {
        Object instance = org.springframework.beans.BeanUtils.instantiate(this.type);
        try {
            BeanUtils.populate((Object)instance, hash);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return (T)instance;
    }

    @Override
    public Map<String, String> toHash(T object) {
        try {
            return BeanUtils.describe(object);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot describe object " + object);
        }
    }
}

