/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.DestinationResolver;

@Configuration
@ConditionalOnClass(value={JmsTemplate.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={JmsProperties.class})
@Import(value={JmsAnnotationDrivenConfiguration.class})
public class JmsAutoConfiguration {
    @Autowired
    private JmsProperties properties;
    @Autowired
    private ConnectionFactory connectionFactory;
    @Autowired(required=false)
    private DestinationResolver destinationResolver;

    @Bean
    @ConditionalOnMissingBean
    public JmsTemplate jmsTemplate() {
        JmsTemplate jmsTemplate = new JmsTemplate(this.connectionFactory);
        jmsTemplate.setPubSubDomain(this.properties.isPubSubDomain());
        if (this.destinationResolver != null) {
            jmsTemplate.setDestinationResolver(this.destinationResolver);
        }
        return jmsTemplate;
    }

    @ConditionalOnClass(value={JmsMessagingTemplate.class})
    @ConditionalOnMissingBean(value={JmsMessagingTemplate.class})
    protected static class MessagingTemplateConfiguration {
        protected MessagingTemplateConfiguration() {
        }

        @Bean
        public JmsMessagingTemplate jmsMessagingTemplate(JmsTemplate jmsTemplate) {
            return new JmsMessagingTemplate(jmsTemplate);
        }
    }
}

