/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.CollectionUtils;

class DefaultListOperations<K, V>
extends AbstractOperations<K, V>
implements ListOperations<K, V> {
    DefaultListOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public V index(K key, final long index) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.lIndex(rawKey, index);
            }
        }, true);
    }

    @Override
    public V leftPop(K key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.lPop(rawKey);
            }
        }, true);
    }

    @Override
    public V leftPop(K key, long timeout, TimeUnit unit) {
        final int tm = (int)TimeoutUtils.toSeconds(timeout, unit);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                List<byte[]> lPop = connection.bLPop(tm, new byte[][]{rawKey});
                return CollectionUtils.isEmpty(lPop) ? null : lPop.get(1);
            }
        }, true);
    }

    @Override
    public Long leftPush(K key, V value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.lPush(rawKey, new byte[][]{rawValue});
            }
        }, true);
    }

    @Override
    public Long leftPushAll(K key, V ... values) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawValues = this.rawValues(values);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.lPush(rawKey, rawValues);
            }
        }, true);
    }

    @Override
    public Long leftPushAll(K key, Collection<V> values) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawValues = this.rawValues(values);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.lPush(rawKey, rawValues);
            }
        }, true);
    }

    @Override
    public Long leftPushIfPresent(K key, V value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.lPushX(rawKey, rawValue);
            }
        }, true);
    }

    @Override
    public Long leftPush(K key, V pivot, V value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawPivot = this.rawValue(pivot);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.lInsert(rawKey, RedisListCommands.Position.BEFORE, rawPivot, rawValue);
            }
        }, true);
    }

    @Override
    public Long size(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.lLen(rawKey);
            }
        }, true);
    }

    @Override
    public List<V> range(K key, final long start, final long end) {
        final byte[] rawKey = this.rawKey(key);
        return (List)this.execute(new RedisCallback<List<V>>(){

            @Override
            public List<V> doInRedis(RedisConnection connection) {
                return DefaultListOperations.this.deserializeValues(connection.lRange(rawKey, start, end));
            }
        }, true);
    }

    @Override
    public Long remove(K key, final long count, Object value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.lRem(rawKey, count, rawValue);
            }
        }, true);
    }

    @Override
    public V rightPop(K key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.rPop(rawKey);
            }
        }, true);
    }

    @Override
    public V rightPop(K key, long timeout, TimeUnit unit) {
        final int tm = (int)TimeoutUtils.toSeconds(timeout, unit);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                List<byte[]> bRPop = connection.bRPop(tm, new byte[][]{rawKey});
                return CollectionUtils.isEmpty(bRPop) ? null : bRPop.get(1);
            }
        }, true);
    }

    @Override
    public Long rightPush(K key, V value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.rPush(rawKey, new byte[][]{rawValue});
            }
        }, true);
    }

    @Override
    public Long rightPushAll(K key, V ... values) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawValues = this.rawValues(values);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.rPush(rawKey, rawValues);
            }
        }, true);
    }

    @Override
    public Long rightPushAll(K key, Collection<V> values) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawValues = this.rawValues(values);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.rPush(rawKey, rawValues);
            }
        }, true);
    }

    @Override
    public Long rightPushIfPresent(K key, V value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.rPushX(rawKey, rawValue);
            }
        }, true);
    }

    @Override
    public Long rightPush(K key, V pivot, V value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawPivot = this.rawValue(pivot);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.lInsert(rawKey, RedisListCommands.Position.AFTER, rawPivot, rawValue);
            }
        }, true);
    }

    @Override
    public V rightPopAndLeftPush(K sourceKey, K destinationKey) {
        final byte[] rawDestKey = this.rawKey(destinationKey);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(sourceKey){

            @Override
            protected byte[] inRedis(byte[] rawSourceKey, RedisConnection connection) {
                return connection.rPopLPush(rawSourceKey, rawDestKey);
            }
        }, true);
    }

    @Override
    public V rightPopAndLeftPush(K sourceKey, K destinationKey, long timeout, TimeUnit unit) {
        final int tm = (int)TimeoutUtils.toSeconds(timeout, unit);
        final byte[] rawDestKey = this.rawKey(destinationKey);
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(sourceKey){

            @Override
            protected byte[] inRedis(byte[] rawSourceKey, RedisConnection connection) {
                return connection.bRPopLPush(tm, rawSourceKey, rawDestKey);
            }
        }, true);
    }

    @Override
    public void set(K key, final long index, V value) {
        final byte[] rawValue = this.rawValue(value);
        this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                connection.lSet(rawKey, index, rawValue);
                return null;
            }
        }, true);
    }

    @Override
    public void trim(K key, final long start, final long end) {
        this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                connection.lTrim(rawKey, start, end);
                return null;
            }
        }, true);
    }
}

