/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.DeveloperDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateDeveloperParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDeveloperService;
import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.MediaCompanyMsgDto;
import cn.com.duiba.tuia.media.api.dto.MediaPersonalMsgDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateAccountFreezeStatus;
import cn.com.duiba.tuia.media.bo.AccountBackendBO;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.BlowfishUtils;
import cn.com.duiba.tuia.media.common.utils.MessageDigestUtils;
import cn.com.duiba.tuia.media.dao.MediaCompanyMsgDAO;
import cn.com.duiba.tuia.media.dao.MediaPersonalMsgDAO;
import cn.com.duiba.tuia.media.domain.AccountBankDto;
import cn.com.duiba.tuia.media.domain.AccountCheckRecordDto;
import cn.com.duiba.tuia.media.model.Email;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqRegister;
import cn.com.duiba.tuia.media.model.rsp.AccountInfoRsp;
import cn.com.duiba.tuia.media.model.rsp.RegisterRsp;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.service.AccountBankService;
import cn.com.duiba.tuia.media.service.AccountCheckRecordService;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.EmailService;
import cn.com.duiba.tuia.media.service.SmsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.redis.RedisClient;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AccountBackendBOImpl
implements AccountBackendBO {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${media.login.encrypt.key}")
    private String loginEncryptKey;
    private ExecutorService executorService = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newFixedThreadPool(3));
    @Autowired
    private AccountService accountService;
    @Autowired
    private EmailService emailService;
    @Autowired
    protected RedisClient redisClient;
    @Autowired
    private AccountCheckRecordService accountCheckRecordService;
    @Autowired
    private RemoteDeveloperService remoteDeveloperService;
    @Value(value="${media.email.verify.key}")
    private String emailVerifyKey;
    @Autowired
    private SmsService smsService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private MediaCompanyMsgDAO mediaCompanyMsgDAO;
    @Autowired
    private MediaPersonalMsgDAO mediaPersonalMsgDAO;
    @Autowired
    private AccountBankService accountBankService;

    @Override
    public RegisterRsp register(final ReqRegister req) throws TuiaMediaException {
        final AccountDto accountDto = new AccountDto();
        if (this.accountService.isEmailExists(req.getEmail())) {
            this.logger.error("the account is exist, the email=[{}]", (Object)req.getEmail());
            throw new TuiaMediaException(ErrorCode.E0102011);
        }
        if (this.accountService.isPhoneExists(req.getLinkPhone()) != null) {
            this.logger.error("the phone is exist");
            throw new TuiaMediaException(ErrorCode.E0102021);
        }
        boolean flag = (Boolean)this.transactionTemplate.execute(new TransactionCallback(){

            public final Object doInTransaction(TransactionStatus status) {
                return AccountBackendBOImpl.this.doRegister(req, accountDto, status);
            }
        });
        if (!flag) {
            this.logger.error("add account error");
            throw new TuiaMediaException(ErrorCode.E0102020);
        }
        this.logger.info("account is register,the email =[{}]", (Object)accountDto.getLinkman());
        this.accountService.doSendVerifyEmail(accountDto);
        RegisterRsp rsp = new RegisterRsp();
        rsp.setcName(accountDto.getLinkman());
        rsp.setEmail(accountDto.getEmail());
        rsp.setMediaId(accountDto.getMediaId());
        return rsp;
    }

    private boolean doRegister(ReqRegister req, AccountDto accountDto, TransactionStatus status) {
        try {
            boolean flag = this.doRegisterBaseInfo(req, accountDto);
            if (!flag) {
                this.logger.error("add account error");
                throw new TuiaMediaException(ErrorCode.E0102020);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("AccountBackendBOImpl.register have error the msg=[{}]", (Throwable)e);
            status.setRollbackOnly();
            return false;
        }
    }

    private boolean doRegisterBaseInfo(ReqRegister req, AccountDto accountDto) throws TuiaMediaException {
        Long mediaId;
        CreateDeveloperParams params = new CreateDeveloperParams();
        params.setEmail(req.getEmail());
        params.setCompany(req.getCompanyName());
        params.setName(req.getLinkman());
        params.setPassword(req.getPassword());
        params.setPhone(req.getLinkPhone());
        DubboResult mediaIdResult = this.remoteDeveloperService.createDeveloper(params, Boolean.valueOf(false));
        if (!mediaIdResult.isSuccess()) {
            this.logger.error("the developer account is exist", (Object)mediaIdResult.getMsg());
            DubboResult developerDtoResult = this.remoteDeveloperService.findDeveloperByEmail(req.getEmail());
            if (!developerDtoResult.isSuccess() || developerDtoResult.getResult() == null) {
                this.logger.error("can not get developer account", (Object)developerDtoResult.getMsg());
                throw new TuiaMediaException(ErrorCode.E0102001);
            }
            mediaId = ((DeveloperDto)developerDtoResult.getResult()).getId();
        } else {
            if (mediaIdResult.getResult() == null) {
                this.logger.error("mediaId is null");
                throw new TuiaMediaException(ErrorCode.E0102001);
            }
            mediaId = (Long)mediaIdResult.getResult();
        }
        String srePassword = BlowfishUtils.encryptBlowfish((String)MessageDigestUtils.sha((String)req.getPassword()), (String)this.loginEncryptKey);
        accountDto.setMediaId(mediaId);
        accountDto.setPassword(srePassword);
        accountDto.setEmail(req.getEmail());
        accountDto.setCompanyName(req.getCompanyName());
        accountDto.setLinkman(req.getLinkman());
        accountDto.setLinkPhone(req.getLinkPhone());
        return this.accountService.insertAccountBase(accountDto);
    }

    @Override
    public Long login(String email, String password) throws TuiaMediaException {
        AccountDto accountDto = this.accountService.selectByEmail(email);
        this.accountService.accountDtoIsNull(accountDto);
        String srePassword = BlowfishUtils.encryptBlowfish((String)MessageDigestUtils.sha((String)password), (String)this.loginEncryptKey);
        if (!StringUtils.equals((String)srePassword, (String)accountDto.getPassword())) {
            this.logger.error("the password is error, email =[{}]", (Object)password);
            throw new TuiaMediaException(ErrorCode.E0102002);
        }
        Long mediaId = accountDto.getMediaId();
        this.emailStatusAuth(accountDto.getEmailStatus());
        this.doCheckFreeze(mediaId, accountDto.getFreezeStatus());
        return mediaId;
    }

    private void emailStatusAuth(Integer eamilStatus) throws TuiaMediaException {
        if (1 != eamilStatus) {
            this.logger.error("the eamil status is illegal, the email status=[{}]", (Object)eamilStatus);
            throw new TuiaMediaException(ErrorCode.E0102019);
        }
    }

    private void doCheckFreeze(long mediaId, Integer freezeStatus) throws TuiaMediaException {
        if (1 == freezeStatus) {
            AccountCheckRecordDto accountCheckRecordDto = this.accountCheckRecordService.selectLatelyCheckRecord(mediaId, 3);
            if (accountCheckRecordDto == null) {
                this.logger.error(" the getAccountCheckRecord is null, the accountId=[{}]", (Object)mediaId);
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            this.logger.error("the account is freeze, the freeze status=[{}]", (Object)freezeStatus);
            throw new TuiaMediaException(ErrorCode.E0102004.getErrorCode(), "\u8d26\u53f7\u88ab\u51bb\u7ed3\uff0c\u56e0\u4e3a\uff1a" + accountCheckRecordDto.getReason());
        }
        if (0 != freezeStatus) {
            this.logger.error("the account freeze status is illegal,  the freeze status=[{}]", (Object)freezeStatus);
            throw new TuiaMediaException(ErrorCode.E0102005);
        }
    }

    @Override
    public AccountInfoRsp getAccountInfo(Long mediaId) throws TuiaMediaException {
        AccountDto accountDto = this.accountService.selectByMediaId(mediaId);
        this.accountService.accountDtoIsNull(accountDto);
        AccountInfoRsp accountInfoRsp = new AccountInfoRsp();
        accountInfoRsp = this.getAccountBaseInfo(accountDto, accountInfoRsp);
        Integer roleType = accountDto.getRoleType();
        if (roleType == AccountDto.ROLE_TYPE_COMPANY) {
            accountInfoRsp = this.getAccountCompanyMsg(mediaId, accountInfoRsp);
        } else if (roleType == AccountDto.ROLE_TYPE_PERSONAL) {
            accountInfoRsp = this.getAccountPersonalMsg(mediaId, accountInfoRsp);
        }
        accountInfoRsp = this.getAccountBankInfo(mediaId, accountInfoRsp);
        return accountInfoRsp;
    }

    private AccountInfoRsp getAccountBankInfo(Long mediaId, AccountInfoRsp accountInfoRsp) throws TuiaMediaException {
        AccountBankDto accountBankDto = this.accountBankService.selectByMediaId(mediaId);
        if (accountBankDto != null) {
            accountInfoRsp.setCardNumber(accountBankDto.getCardNumber());
            accountInfoRsp.setBankName(accountBankDto.getBankName());
            accountInfoRsp.setProvince(accountBankDto.getProvince());
            accountInfoRsp.setCity(accountBankDto.getCity());
            accountInfoRsp.setBranchName(accountBankDto.getBranchName());
        }
        return accountInfoRsp;
    }

    private AccountInfoRsp getAccountBaseInfo(AccountDto accountDto, AccountInfoRsp accountInfoRsp) {
        accountInfoRsp.setMediaId(accountDto.getMediaId());
        accountInfoRsp.setCompanyName(accountDto.getCompanyName());
        accountInfoRsp.setEmail(accountDto.getEmail());
        accountInfoRsp.setLinkman(accountDto.getLinkman());
        accountInfoRsp.setLinkPhone(accountDto.getLinkPhone());
        Integer roleType = accountDto.getRoleType();
        if (roleType != null && roleType != AccountDto.ROLE_TYPE_DEFAULT) {
            accountInfoRsp.setRoleType(accountDto.getRoleType());
            accountInfoRsp.setEdited(true);
        } else {
            accountInfoRsp.setEdited(false);
        }
        return accountInfoRsp;
    }

    private AccountInfoRsp getAccountCompanyMsg(Long mediaId, AccountInfoRsp accountInfoRsp) throws TuiaMediaException {
        MediaCompanyMsgDto companyMsgDto = this.mediaCompanyMsgDAO.selectCompanyMsgById(mediaId);
        if (companyMsgDto != null) {
            accountInfoRsp.setFinanceCompanyName(companyMsgDto.getFinanceCompanyName());
            accountInfoRsp.setBusinessLicenseId(companyMsgDto.getBusinessLicenseId());
            accountInfoRsp.setBusinessLicenseUrl(companyMsgDto.getBusinessLicenseUrl());
        }
        return accountInfoRsp;
    }

    private AccountInfoRsp getAccountPersonalMsg(Long mediaId, AccountInfoRsp accountInfoRsp) throws TuiaMediaException {
        MediaPersonalMsgDto personalMsgDto = this.mediaPersonalMsgDAO.selectPersonalMsgById(mediaId);
        if (personalMsgDto != null) {
            accountInfoRsp.setPersonalName(personalMsgDto.getPersonalName());
            accountInfoRsp.setIdCard(personalMsgDto.getIdCard());
            accountInfoRsp.setIdCardFrontUrl(personalMsgDto.getIdCardFrontUrl());
            accountInfoRsp.setIdCardBackUrl(personalMsgDto.getIdCardBackUrl());
        }
        return accountInfoRsp;
    }

    @Override
    public boolean updateFreezeStatus(Long mediaId, Integer checkType, String reason) throws TuiaMediaException {
        boolean flag;
        int status = -1;
        String checkTypeMessage = "\u89e3\u51bb";
        if (ReqUpdateAccountFreezeStatus.PARAM_UNFREEZE.intValue() == checkType.intValue()) {
            status = 0;
        }
        if (ReqUpdateAccountFreezeStatus.PARAM_FREEZE.intValue() == checkType.intValue()) {
            checkTypeMessage = "\u51bb\u7ed3";
            status = 1;
        }
        if (flag = this.accountService.updateFreezeStatus(mediaId, status)) {
            AccountCheckRecordDto checkRecord = new AccountCheckRecordDto();
            checkRecord.setMediaId(mediaId);
            checkRecord.setCheckType(checkType);
            checkRecord.setReason(reason);
            checkRecord.setGmtCreate(checkRecord.getGmtCreate());
            checkRecord.setGmtModified(checkRecord.getGmtModified());
            this.accountCheckRecordService.insertCheckRecord(checkRecord);
            AccountDto mediaDto = this.accountService.selectByMediaId(mediaId);
            if (mediaDto == null || mediaDto.getEmail() == null) {
                this.logger.error("the media is not exist, the mediaId=[{}]", (Object)mediaId);
                throw new TuiaMediaException(ErrorCode.E0102001);
            }
            this.doSendEmail(checkTypeMessage, mediaDto);
            return true;
        }
        return false;
    }

    private void doSendEmail(String checkTypeMessage, AccountDto accountDto) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("linkman", accountDto.getLinkman());
        model.put("email", accountDto.getEmail());
        model.put("checkTypeMessage", checkTypeMessage);
        final Email email = new Email();
        email.setTo(accountDto.getEmail());
        email.setTemplateLocation("/templates/mail/checkStatus.vm");
        email.setSubject("\u8d26\u53f7\u72b6\u6001\u53d8\u5316\u901a\u77e5");
        email.setModel(model);
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                AccountBackendBOImpl.this.emailService.sendWithTemplate(email);
            }
        });
    }

    @Override
    public AccountDto selectAccountByEmail(String email) throws TuiaMediaException {
        return this.accountService.selectByEmail(email);
    }

    @Override
    public List<AccountDto> selectAccountByIds(List<Long> mediaIds) throws TuiaMediaException {
        List<IdAndName> idsAndNames = this.accountService.selectIdAndNameByIds(mediaIds);
        ArrayList<AccountDto> result = new ArrayList<AccountDto>();
        for (IdAndName idAndName : idsAndNames) {
            result.add(IdAndNameParser.parseToAccountDto(idAndName));
        }
        return result;
    }
}

