/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityCacheService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityDAOImpl
extends BaseDAO
implements ActivityDAO {
    @Autowired
    private ActivityCacheService activityCacheService;

    @Override
    public int insert(ActivityDto activityDto) throws TuiaMediaException {
        try {
            return this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)activityDto);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.insert happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int update(ActivityDto activityDto) throws TuiaMediaException {
        try {
            int line = this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)activityDto);
            if (line == 1) {
                ActivityDto newActivityDto = this.getDetail(activityDto.getActivityId(), activityDto.getActivityType());
                this.activityCacheService.set(newActivityDto);
            }
            return line;
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.update happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivityDto> getList(ReqActivityDto req) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("getList"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.getList happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int getListAmount(ReqActivityDto req) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("getListAmount"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.getListAmount happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivityDto> getByIds(List<Long> ids, Integer actSource) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return new ArrayList<ActivityDto>();
            }
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("source", actSource);
            param.put("ids", ids);
            return this.getSqlSession().selectList(this.getStamentNameSpace("getByActivityIds"), param);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.getByIds happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public ActivityDto getDetail(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return (ActivityDto)((Object)this.getSqlSession().selectOne(this.getStamentNameSpace("getDetail"), map));
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.getDetail happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public ActivityDto getDetailBySource(Long activityId, Integer source) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("source", source);
            return (ActivityDto)((Object)this.getSqlSession().selectOne(this.getStamentNameSpace("getDetailBySource"), map));
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.getDetailBySource happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<Long> getIdsByName(String name) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("getIdsByName"), (Object)name);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.getIdsByName happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivityDto> selectEngineActivityList() throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectOldActivity"));
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.selectEngineActivityList happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivityDto> selectNewActivityList() throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectNewActivity"));
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.selectNewActivityList happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<Long> selectActivityIdsByName(String activityName) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectActivityIdsByName"), (Object)activityName);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.selectActivityIdsByName happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<Long> selectBySource(int source, int limit) throws TuiaMediaException {
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("source", source);
            map.put("limit", limit);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectBySource"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.selectBySource happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivityDto> getDetail4List(List<Long> activityIds, List<Integer> activityTypes) throws TuiaMediaException {
        try {
            HashMap<String, List<Number>> map = new HashMap<String, List<Number>>();
            map.put("activityIds", activityIds);
            map.put("activityTypes", activityTypes);
            return this.getSqlSession().selectList(this.getStamentNameSpace("getDetail4List"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.getDetail4List happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivityDto> getDetail4ListBySource(List<Long> activityIds, List<Integer> sources) throws TuiaMediaException {
        try {
            HashMap<String, List<Number>> map = new HashMap<String, List<Number>>();
            map.put("activityIds", activityIds);
            map.put("sources", sources);
            return this.getSqlSession().selectList(this.getStamentNameSpace("getDetail4ListBySource"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.getDetail4ListBySource happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

