/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.message.consumer;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.message.body.AdActivityMessage;
import cn.com.duiba.tuia.media.message.consumer.AbstractKafkaConsumer;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.utils.JsonUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ActivityKafkaConsumer
extends AbstractKafkaConsumer {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivitySortService activitySortService;
    @Value(value="${media.kafka.activity.topic}")
    private String topic;

    @Override
    protected List<String> getTopics() {
        return Arrays.asList(this.topic);
    }

    @Override
    protected void readMessage(ConsumerRecord<String, String> record) {
        String key = (String)record.key();
        String message = (String)record.value();
        Long offset = record.offset();
        try {
            this.log.info("ActivityKafkaConsumer begin message consume, key=[{}], offset=[{}], message=[{}]", new Object[]{key, offset, message});
            AdActivityMessage adActivityMessage = JsonUtils.jsonToObject(AdActivityMessage.class, message);
            if (adActivityMessage != null) {
                switch (adActivityMessage.getAction()) {
                    case "insert": {
                        this.createActivityDto(adActivityMessage);
                        break;
                    }
                    case "update": {
                        this.updateActivityDto(adActivityMessage);
                        break;
                    }
                    case "delete": {
                        this.deleteActivityDto(adActivityMessage);
                        break;
                    }
                }
            }
            this.log.info("ActivityKafkaConsumer end message consume");
        }
        catch (Exception e) {
            this.log.error(String.format("ActivityKafkaConsumer error, key=[%s], offset=[%s], message=[%s]", key, offset, message), (Throwable)e);
        }
    }

    private void deleteActivityDto(AdActivityMessage adActivityMessage) throws TuiaMediaException {
        this.activityService.deleteActivity(adActivityMessage.getActivityId(), adActivityMessage.getActivityType());
        this.activitySortService.deleteActivity(adActivityMessage.getActivityId(), adActivityMessage.getActivityType(), null);
    }

    private void updateActivityDto(AdActivityMessage adActivityMessage) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(adActivityMessage.getActivityId());
        activityDto.setActivityType(adActivityMessage.getActivityType());
        if (adActivityMessage.getActivityStatus() != null) {
            activityDto.setActivityStatus(adActivityMessage.getActivityStatus());
        }
        if (adActivityMessage.getActivityName() != null) {
            activityDto.setActivityName(adActivityMessage.getActivityName());
        }
        if (adActivityMessage.getTag() != null) {
            activityDto.setTag(adActivityMessage.getTag());
        }
        this.activityService.updateActivity(activityDto);
    }

    private void createActivityDto(AdActivityMessage adActivityMessage) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(adActivityMessage.getActivityId());
        activityDto.setActivityStatus(adActivityMessage.getActivityStatus());
        activityDto.setActivityType(adActivityMessage.getActivityType());
        activityDto.setActivityName(adActivityMessage.getActivityName());
        activityDto.setTag(adActivityMessage.getTag());
        activityDto.setIsPublish(0);
        activityDto.setSource(0);
        this.activityService.insertActivity(activityDto);
    }
}

