/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.cacheservice;

import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.MediaAppActivityDAO;
import cn.com.duiba.tuia.media.dataobject.MediaAppActivityDO;
import cn.com.duiba.wolf.redis.RedisClient;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActivityDirectAppCacheService {
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private MediaAppActivityDAO mediaAppActivityDAO;
    private static final String NO_APP = "NO_APP";

    public List<Long> get(Long activityId, Integer activityType) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivity_direct_app_key((Long)activityId, (Integer)activityType);
        String value = this.redisClient.get(key);
        if (NO_APP.equals(value)) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((Object)value)) {
            List<Long> appList = this.mediaAppActivityDAO.getMediaAppByActivity(activityId, activityType);
            this.set(activityId, activityType, appList);
            return appList;
        }
        ArrayList<Long> appList = new ArrayList<Long>();
        for (String appId : value.split(",")) {
            appList.add(Long.parseLong(appId));
        }
        return appList;
    }

    public List<Long> getBySource(Long activityId, Integer source) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityDirectAppKeyBySource((Long)activityId, (Integer)source);
        String value = this.redisClient.get(key);
        if (NO_APP.equals(value)) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((Object)value)) {
            List<Long> appList = this.mediaAppActivityDAO.getMediaAppByActivityAndSource(activityId, source);
            this.setBySource(activityId, source, appList);
            return appList;
        }
        ArrayList<Long> appList = new ArrayList<Long>();
        for (String appId : value.split(",")) {
            appList.add(Long.parseLong(appId));
        }
        return appList;
    }

    public List<MediaAppActivityDO> get4List(List<Long> activityIds, List<Integer> activityTypes) throws TuiaMediaException {
        List<Object> mediaAppActivityDOs = Lists.newArrayList();
        if (CollectionUtils.isEmpty(activityIds) || CollectionUtils.isEmpty(activityTypes)) {
            return mediaAppActivityDOs;
        }
        mediaAppActivityDOs = this.mediaAppActivityDAO.getMediaAppByActivity4List(activityIds, activityTypes);
        return mediaAppActivityDOs;
    }

    public List<MediaAppActivityDO> get4ListBySources(List<Long> activityIds, List<Integer> sources) throws TuiaMediaException {
        List<Object> mediaAppActivityDOs = Lists.newArrayList();
        if (CollectionUtils.isEmpty(activityIds) || CollectionUtils.isEmpty(sources)) {
            return mediaAppActivityDOs;
        }
        mediaAppActivityDOs = this.mediaAppActivityDAO.getMediaAppByActivity4ListBySource(activityIds, sources);
        return mediaAppActivityDOs;
    }

    public void set(Long activityId, Integer activityType, List<Long> appList) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivity_direct_app_key((Long)activityId, (Integer)activityType);
        if (CollectionUtils.isEmpty(appList)) {
            this.redisClient.setex(key, 86400, NO_APP);
            return;
        }
        StringBuilder sb = new StringBuilder();
        String value = Joiner.on((String)",").appendTo(sb, appList).toString();
        this.redisClient.setex(key, 86400, value);
    }

    public void setBySource(Long activityId, Integer source, List<Long> appList) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityDirectAppKeyBySource((Long)activityId, (Integer)source);
        if (CollectionUtils.isEmpty(appList)) {
            this.redisClient.setex(key, 86400, NO_APP);
            return;
        }
        StringBuilder sb = new StringBuilder();
        String value = Joiner.on((String)",").appendTo(sb, appList).toString();
        this.redisClient.setex(key, 86400, value);
    }
}

