/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityAdvertDAO;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityAdvertDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.ActivityAdvertService;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityAdvertCacheService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activityAdvertService")
public class ActivityAdvertServiceImpl
implements ActivityAdvertService {
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private ActivityAdvertDAO activityAdvertDAO;
    @Autowired
    private ActivityAdvertCacheService activityAdvertCacheService;

    @Override
    public Boolean activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, Integer directMode, List<Long> advertIds) throws TuiaMediaException {
        if (1 != directStatus && 0 != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (1 != directMode && 2 != directMode) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsDirectAdvert(directStatus);
        activityDto.setDirectAdvertMode(directMode);
        this.activityDAO.update(activityDto);
        this.activityAdvertDAO.delete(activityId, activityType);
        if (!CollectionUtils.isEmpty(advertIds)) {
            ArrayList<ActivityAdvertDO> list = new ArrayList<ActivityAdvertDO>(advertIds.size());
            for (Long advertId : advertIds) {
                ActivityAdvertDO activityAdvertDO = new ActivityAdvertDO();
                activityAdvertDO.setActivityId(activityId);
                activityAdvertDO.setActivityType(activityType);
                activityAdvertDO.setAdvertId(advertId);
                list.add(activityAdvertDO);
            }
            this.activityAdvertDAO.insertBatch(list);
        }
        this.activityAdvertCacheService.set(activityId, activityType, advertIds);
        return true;
    }

    @Override
    public List<Long> getActivityAdvertIds(Long activityId, Integer activityType) throws TuiaMediaException {
        return this.activityAdvertCacheService.get(activityId, activityType);
    }

    @Override
    public Boolean activityDirectToAdvertBySource(Long activityId, Integer source, Integer directStatus, Integer directMode, List<Long> advertIds) throws TuiaMediaException {
        if (1 != directStatus && 0 != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (1 != directMode && 2 != directMode) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setSource(source);
        activityDto.setIsDirectAdvert(directStatus);
        activityDto.setDirectAdvertMode(directMode);
        this.activityDAO.update(activityDto);
        this.activityAdvertDAO.deleteBySource(activityId, source);
        if (!CollectionUtils.isEmpty(advertIds)) {
            ArrayList<ActivityAdvertDO> list = new ArrayList<ActivityAdvertDO>(advertIds.size());
            for (Long advertId : advertIds) {
                ActivityAdvertDO activityAdvertDO = new ActivityAdvertDO();
                activityAdvertDO.setActivityId(activityId);
                activityAdvertDO.setSource(source);
                activityAdvertDO.setAdvertId(advertId);
                list.add(activityAdvertDO);
            }
            this.activityAdvertDAO.insertBatch(list);
        }
        this.activityAdvertCacheService.setBySource(activityId, source, advertIds);
        return true;
    }

    @Override
    public List<Long> getActivityAdvertIdsBySource(Long activityId, Integer source) throws TuiaMediaException {
        return this.activityAdvertCacheService.getBySource(activityId, source);
    }
}

