/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache.web;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.boot.autoconfigure.mustache.web.MustacheView;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public class MustacheViewResolver
extends UrlBasedViewResolver {
    private Mustache.Compiler compiler = Mustache.compiler();
    private String charset;

    public MustacheViewResolver() {
        this.setViewClass(this.requiredViewClass());
    }

    protected Class<?> requiredViewClass() {
        return MustacheView.class;
    }

    public void setCompiler(Mustache.Compiler compiler) {
        this.compiler = compiler;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        Resource resource = this.resolveResource(viewName, locale);
        if (resource == null) {
            return null;
        }
        MustacheView mustacheView = (MustacheView)super.loadView(viewName, locale);
        mustacheView.setTemplate(this.createTemplate(resource));
        return mustacheView;
    }

    private Resource resolveResource(String viewName, Locale locale) {
        return this.resolveFromLocale(viewName, this.getLocale(locale));
    }

    private Resource resolveFromLocale(String viewName, String locale) {
        Resource resource = this.getApplicationContext().getResource(this.getPrefix() + viewName + locale + this.getSuffix());
        if (resource == null || !resource.exists()) {
            if (locale.isEmpty()) {
                return null;
            }
            int index = locale.lastIndexOf("_");
            return this.resolveFromLocale(viewName, locale.substring(0, index));
        }
        return resource;
    }

    private String getLocale(Locale locale) {
        if (locale == null) {
            return "";
        }
        LocaleEditor localeEditor = new LocaleEditor();
        localeEditor.setValue((Object)locale);
        return "_" + localeEditor.getAsText();
    }

    private Template createTemplate(Resource resource) throws IOException {
        return this.compiler.compile(this.getReader(resource));
    }

    private Reader getReader(Resource resource) throws IOException {
        if (this.charset != null) {
            return new InputStreamReader(resource.getInputStream(), this.charset);
        }
        return new InputStreamReader(resource.getInputStream());
    }
}

