/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.buffer;

import com.alibaba.dubbo.remoting.buffer.AbstractChannelBuffer;
import com.alibaba.dubbo.remoting.buffer.ChannelBuffer;
import com.alibaba.dubbo.remoting.buffer.ChannelBufferFactory;
import com.alibaba.dubbo.remoting.buffer.HeapChannelBufferFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class DynamicChannelBuffer
extends AbstractChannelBuffer {
    private final ChannelBufferFactory factory;
    private ChannelBuffer buffer;

    public DynamicChannelBuffer(int estimatedLength) {
        this(estimatedLength, HeapChannelBufferFactory.getInstance());
    }

    public DynamicChannelBuffer(int estimatedLength, ChannelBufferFactory factory) {
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
        this.buffer = factory.getBuffer(estimatedLength);
    }

    public void ensureWritableBytes(int minWritableBytes) {
        int newCapacity;
        if (minWritableBytes <= this.writableBytes()) {
            return;
        }
        int minNewCapacity = this.writerIndex() + minWritableBytes;
        for (newCapacity = this.capacity() == 0 ? 1 : this.capacity(); newCapacity < minNewCapacity; newCapacity <<= 1) {
        }
        ChannelBuffer newBuffer = this.factory().getBuffer(newCapacity);
        newBuffer.writeBytes(this.buffer, 0, this.writerIndex());
        this.buffer = newBuffer;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public ChannelBuffer copy(int index, int length) {
        DynamicChannelBuffer copiedBuffer = new DynamicChannelBuffer(Math.max(length, 64), this.factory());
        copiedBuffer.buffer = this.buffer.copy(index, length);
        copiedBuffer.setIndex(0, length);
        return copiedBuffer;
    }

    public ChannelBufferFactory factory() {
        return this.factory;
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    public void getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    public void getBytes(int index, OutputStream dst, int length) throws IOException {
        this.buffer.getBytes(index, dst, length);
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public void setByte(int index, int value) {
        this.buffer.setByte(index, value);
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    public void setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
    }

    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    public int setBytes(int index, InputStream src, int length) throws IOException {
        return this.buffer.setBytes(index, src, length);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.toByteBuffer(index, length);
    }

    public void writeByte(int value) {
        this.ensureWritableBytes(1);
        super.writeByte(value);
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.ensureWritableBytes(length);
        super.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        this.ensureWritableBytes(length);
        super.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(ByteBuffer src) {
        this.ensureWritableBytes(src.remaining());
        super.writeBytes(src);
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        this.ensureWritableBytes(length);
        return super.writeBytes(in, length);
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }
}

