/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.message.Event;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultEvent;
import com.dianping.cat.message.internal.DefaultHeartbeat;
import com.dianping.cat.message.internal.DefaultMetric;
import com.dianping.cat.message.internal.DefaultTransaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class MockMessageBuilder {
    private Stack<TransactionHolder> m_stack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message build() {
        try {
            Message message = this.define().build();
            return message;
        }
        finally {
            this.m_stack.clear();
        }
    }

    public abstract MessageHolder define();

    protected EventHolder e(String type, String name) {
        TransactionHolder parent;
        EventHolder e = new EventHolder(type, name);
        TransactionHolder transactionHolder = parent = this.m_stack.isEmpty() ? null : this.m_stack.peek();
        if (parent != null) {
            e.setTimestampInMicros(parent.getCurrentTimestampInMicros());
        }
        return e;
    }

    protected EventHolder e(String type, String name, String data) {
        TransactionHolder parent;
        EventHolder e = new EventHolder(type, name, data);
        TransactionHolder transactionHolder = parent = this.m_stack.isEmpty() ? null : this.m_stack.peek();
        if (parent != null) {
            e.setTimestampInMicros(parent.getCurrentTimestampInMicros());
        }
        return e;
    }

    protected HeartbeatHolder h(String type, String name) {
        TransactionHolder parent;
        HeartbeatHolder h = new HeartbeatHolder(type, name);
        TransactionHolder transactionHolder = parent = this.m_stack.isEmpty() ? null : this.m_stack.peek();
        if (parent != null) {
            h.setTimestampInMicros(parent.getCurrentTimestampInMicros());
        }
        return h;
    }

    protected MetricHolder m(String type, String name) {
        TransactionHolder parent;
        MetricHolder e = new MetricHolder(type, name);
        TransactionHolder transactionHolder = parent = this.m_stack.isEmpty() ? null : this.m_stack.peek();
        if (parent != null) {
            e.setTimestampInMicros(parent.getCurrentTimestampInMicros());
        }
        return e;
    }

    protected MetricHolder m(String type, String name, String data) {
        TransactionHolder parent;
        MetricHolder e = new MetricHolder(type, name, data);
        TransactionHolder transactionHolder = parent = this.m_stack.isEmpty() ? null : this.m_stack.peek();
        if (parent != null) {
            e.setTimestampInMicros(parent.getCurrentTimestampInMicros());
        }
        return e;
    }

    protected TransactionHolder t(String type, String name, long durationInMillis) {
        TransactionHolder parent;
        TransactionHolder t = new TransactionHolder(type, name, durationInMillis);
        TransactionHolder transactionHolder = parent = this.m_stack.isEmpty() ? null : this.m_stack.peek();
        if (parent != null) {
            t.setTimestampInMicros(parent.getCurrentTimestampInMicros());
        }
        this.m_stack.push(t);
        return t;
    }

    protected TransactionHolder t(String type, String name, String data, long durationInMillis) {
        TransactionHolder parent;
        TransactionHolder t = new TransactionHolder(type, name, data, durationInMillis);
        TransactionHolder transactionHolder = parent = this.m_stack.isEmpty() ? null : this.m_stack.peek();
        if (parent != null) {
            t.setTimestampInMicros(parent.getCurrentTimestampInMicros());
        }
        this.m_stack.push(t);
        return t;
    }

    protected class TransactionHolder
    extends AbstractMessageHolder {
        private long m_durationInMicros;
        private long m_currentTimestampInMicros;
        private List<MessageHolder> m_children;
        private DefaultTransaction m_transaction;
        private long m_markTimestampInMicros;

        public TransactionHolder(String type, String name, long durationInMicros) {
            super(type, name);
            this.m_children = new ArrayList<MessageHolder>();
            this.m_durationInMicros = durationInMicros;
        }

        public TransactionHolder(String type, String name, String data, long durationInMicros) {
            super(type, name, data);
            this.m_children = new ArrayList<MessageHolder>();
            this.m_durationInMicros = durationInMicros;
        }

        public TransactionHolder after(long periodInMicros) {
            this.m_currentTimestampInMicros += periodInMicros;
            return this;
        }

        public TransactionHolder at(long timestampInMillis) {
            this.m_currentTimestampInMicros = timestampInMillis * 1000L;
            this.setTimestampInMicros(this.m_currentTimestampInMicros);
            return this;
        }

        public Transaction build() {
            this.m_transaction = new DefaultTransaction(this.getType(), this.getName(), null);
            this.m_transaction.setTimestamp(this.getTimestampInMillis());
            for (MessageHolder child : this.m_children) {
                this.m_transaction.addChild(child.build());
            }
            this.m_transaction.setStatus(this.getStatus());
            this.m_transaction.addData(this.getData());
            this.m_transaction.complete();
            this.m_transaction.setDurationInMicros(this.m_durationInMicros);
            return this.m_transaction;
        }

        public TransactionHolder child(MessageHolder child) {
            if (child instanceof TransactionHolder) {
                this.m_currentTimestampInMicros += ((TransactionHolder)child).getDurationInMicros();
                MockMessageBuilder.this.m_stack.pop();
            }
            this.m_children.add(child);
            return this;
        }

        public TransactionHolder data(String key, String value) {
            this.addData(key, value);
            return this;
        }

        public long getCurrentTimestampInMicros() {
            return this.m_currentTimestampInMicros;
        }

        public long getDurationInMicros() {
            return this.m_durationInMicros;
        }

        public TransactionHolder mark() {
            this.m_markTimestampInMicros = this.m_currentTimestampInMicros;
            return this;
        }

        public TransactionHolder reset() {
            this.m_currentTimestampInMicros = this.m_markTimestampInMicros;
            return this;
        }

        public void setTimestampInMicros(long timestampInMicros) {
            super.setTimestampInMicros(timestampInMicros);
            this.m_currentTimestampInMicros = timestampInMicros;
        }

        public TransactionHolder status(String status) {
            this.setStatus(status);
            return this;
        }
    }

    protected static class MetricHolder
    extends AbstractMessageHolder {
        private DefaultMetric m_metric;

        public MetricHolder(String type, String name) {
            super(type, name);
        }

        public MetricHolder(String type, String name, String data) {
            super(type, name, data);
        }

        public Metric build() {
            this.m_metric = new DefaultMetric(this.getType(), this.getName());
            this.m_metric.setTimestamp(this.getTimestampInMillis());
            this.m_metric.setStatus(this.getStatus());
            this.m_metric.addData(this.getData());
            this.m_metric.complete();
            return this.m_metric;
        }

        public MetricHolder status(String status) {
            this.setStatus(status);
            return this;
        }
    }

    protected static interface MessageHolder {
        public Message build();

        public long getTimestampInMicros();

        public void setTimestampInMicros(long var1);
    }

    protected static class HeartbeatHolder
    extends AbstractMessageHolder {
        private DefaultHeartbeat m_heartbeat;

        public HeartbeatHolder(String type, String name) {
            super(type, name);
        }

        public Heartbeat build() {
            this.m_heartbeat = new DefaultHeartbeat(this.getType(), this.getName());
            this.m_heartbeat.setTimestamp(this.getTimestampInMillis());
            this.m_heartbeat.setStatus(this.getStatus());
            this.m_heartbeat.complete();
            return this.m_heartbeat;
        }

        public HeartbeatHolder status(String status) {
            this.setStatus(status);
            return this;
        }
    }

    public static class EventHolder
    extends AbstractMessageHolder {
        private DefaultEvent m_event;

        public EventHolder(String type, String name) {
            super(type, name);
        }

        public EventHolder(String type, String name, String data) {
            super(type, name, data);
        }

        public Event build() {
            this.m_event = new DefaultEvent(this.getType(), this.getName(), null);
            this.m_event.setTimestamp(this.getTimestampInMillis());
            this.m_event.setStatus(this.getStatus());
            this.m_event.addData(this.getData());
            this.m_event.complete();
            return this.m_event;
        }

        public EventHolder status(String status) {
            this.setStatus(status);
            return this;
        }
    }

    protected static abstract class AbstractMessageHolder
    implements MessageHolder {
        private String m_type;
        private String m_name;
        private String m_data;
        private long m_timestampInMicros;
        private String m_status = "0";

        public AbstractMessageHolder(String type, String name) {
            this.m_type = type;
            this.m_name = name;
        }

        public AbstractMessageHolder(String type, String name, String data) {
            this.m_type = type;
            this.m_name = name;
            this.m_data = data;
        }

        public void addData(String key, String value) {
            this.m_data = this.m_data == null ? key + "=" + value : this.m_data + "&" + key + "=" + value;
        }

        public String getData() {
            return this.m_data;
        }

        public String getName() {
            return this.m_name;
        }

        public String getStatus() {
            return this.m_status;
        }

        public long getTimestampInMicros() {
            return this.m_timestampInMicros;
        }

        public long getTimestampInMillis() {
            return this.m_timestampInMicros / 1000L;
        }

        public String getType() {
            return this.m_type;
        }

        public void setStatus(String status) {
            this.m_status = status;
        }

        public void setTimestampInMicros(long timestampInMicros) {
            this.m_timestampInMicros = timestampInMicros;
        }
    }
}

