/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.AlipayEbppOweBillUploadResponse;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlipayEbppOweBillUploadRequest
implements TaobaoUploadRequest<AlipayEbppOweBillUploadResponse> {
    private TaobaoHashMap udfParams;
    private Long timestamp;
    private String chargeInst;
    private String chargeoffInst;
    private String digestOweBill;
    private String orderType;
    private FileItem oweBill;
    private String subOrderType;
    private Map<String, String> headerMap = new TaobaoHashMap();

    public void setChargeInst(String chargeInst) {
        this.chargeInst = chargeInst;
    }

    public String getChargeInst() {
        return this.chargeInst;
    }

    public void setChargeoffInst(String chargeoffInst) {
        this.chargeoffInst = chargeoffInst;
    }

    public String getChargeoffInst() {
        return this.chargeoffInst;
    }

    public void setDigestOweBill(String digestOweBill) {
        this.digestOweBill = digestOweBill;
    }

    public String getDigestOweBill() {
        return this.digestOweBill;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOweBill(FileItem oweBill) {
        this.oweBill = oweBill;
    }

    public FileItem getOweBill() {
        return this.oweBill;
    }

    public void setSubOrderType(String subOrderType) {
        this.subOrderType = subOrderType;
    }

    public String getSubOrderType() {
        return this.subOrderType;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getApiMethodName() {
        return "alipay.ebpp.owe.bill.upload";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("charge_inst", this.chargeInst);
        txtParams.put("chargeoff_inst", this.chargeoffInst);
        txtParams.put("digest_owe_bill", this.digestOweBill);
        txtParams.put("order_type", this.orderType);
        txtParams.put("sub_order_type", this.subOrderType);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public void putOtherTextParam(String key, String value) {
        if (this.udfParams == null) {
            this.udfParams = new TaobaoHashMap();
        }
        this.udfParams.put(key, value);
    }

    @Override
    public Map<String, FileItem> getFileParams() {
        HashMap<String, FileItem> params = new HashMap<String, FileItem>();
        params.put("owe_bill", this.oweBill);
        return params;
    }

    @Override
    public Class<AlipayEbppOweBillUploadResponse> getResponseClass() {
        return AlipayEbppOweBillUploadResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.chargeInst, "chargeInst");
        RequestCheckUtils.checkMaxLength(this.chargeInst, 80, "chargeInst");
        RequestCheckUtils.checkMaxLength(this.chargeoffInst, 30, "chargeoffInst");
        RequestCheckUtils.checkNotEmpty(this.orderType, "orderType");
        RequestCheckUtils.checkMaxLength(this.orderType, 10, "orderType");
        RequestCheckUtils.checkNotEmpty(this.oweBill, "oweBill");
        RequestCheckUtils.checkMaxLength(this.oweBill, 0x3200000, "oweBill");
        RequestCheckUtils.checkNotEmpty(this.subOrderType, "subOrderType");
        RequestCheckUtils.checkMaxLength(this.subOrderType, 10, "subOrderType");
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }
}

