/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.AlipayPointOrderGetResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlipayPointOrderGetRequest
implements TaobaoRequest<AlipayPointOrderGetResponse> {
    private Map<String, String> headerMap = new TaobaoHashMap();
    private TaobaoHashMap udfParams;
    private Long timestamp;
    private String authToken;
    private String merchantOrderNo;
    private String userSymbol;
    private String userSymbolType;

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setMerchantOrderNo(String merchantOrderNo) {
        this.merchantOrderNo = merchantOrderNo;
    }

    public String getMerchantOrderNo() {
        return this.merchantOrderNo;
    }

    public void setUserSymbol(String userSymbol) {
        this.userSymbol = userSymbol;
    }

    public String getUserSymbol() {
        return this.userSymbol;
    }

    public void setUserSymbolType(String userSymbolType) {
        this.userSymbolType = userSymbolType;
    }

    public String getUserSymbolType() {
        return this.userSymbolType;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getApiMethodName() {
        return "alipay.point.order.get";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("auth_token", this.authToken);
        txtParams.put("merchant_order_no", this.merchantOrderNo);
        txtParams.put("user_symbol", this.userSymbol);
        txtParams.put("user_symbol_type", this.userSymbolType);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public void putOtherTextParam(String key, String value) {
        if (this.udfParams == null) {
            this.udfParams = new TaobaoHashMap();
        }
        this.udfParams.put(key, value);
    }

    @Override
    public Class<AlipayPointOrderGetResponse> getResponseClass() {
        return AlipayPointOrderGetResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.merchantOrderNo, "merchantOrderNo");
        RequestCheckUtils.checkNotEmpty(this.userSymbol, "userSymbol");
        RequestCheckUtils.checkNotEmpty(this.userSymbolType, "userSymbolType");
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }
}

