/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.formatter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.unidal.formatter.Formatter;
import org.unidal.formatter.FormatterException;
import org.unidal.lookup.annotation.Named;

@Named(type=Formatter.class, value="java.util.Date")
public class DateFormatter
implements Formatter<Date> {
    private static final InheritableThreadLocal<Manager> MANAGER = new InheritableThreadLocal<Manager>(){

        @Override
        protected Manager initialValue() {
            return new Manager();
        }
    };

    @Override
    public Date parse(String format, String text) throws FormatterException {
        SimpleDateFormat dateFormat = ((Manager)MANAGER.get()).getDateFormat(format);
        try {
            return dateFormat.parse(text.trim());
        }
        catch (ParseException e) {
            throw new FormatterException("Error when parsing date(" + dateFormat.toPattern() + ") from " + text, e);
        }
    }

    @Override
    public String format(String format, Date object) throws FormatterException {
        SimpleDateFormat dateFormat = ((Manager)MANAGER.get()).getDateFormat(format);
        return dateFormat.format(object);
    }

    static final class Manager {
        private Map<String, SimpleDateFormat> m_map = new HashMap<String, SimpleDateFormat>();

        Manager() {
        }

        public SimpleDateFormat getDateFormat(String format) {
            SimpleDateFormat dateFormat = this.m_map.get(format);
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(format, Locale.US);
                this.m_map.put(format, dateFormat);
            }
            return dateFormat;
        }
    }
}

