/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.manager.ComponentManagerFactory;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.lifecycle.AbstractLifecycleHandler;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.unidal.helper.Reflects;
import org.unidal.lookup.extension.EnumComponentManagerFactory;
import org.unidal.lookup.extension.PostConstructionPhase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContainerLoader {
    private static volatile DefaultPlexusContainer s_container;
    private static ConcurrentMap<Key, Object> m_components;

    public static void destroyDefaultContainer() {
        if (s_container != null) {
            m_components.clear();
            s_container.dispose();
            s_container = null;
        }
    }

    private static Class<?> findLoaderClass() {
        String loaderClassName = "com.site.lookup.ContainerLoader";
        Class<?> loaderClass = null;
        try {
            loaderClass = ContainerLoader.class.getClassLoader().loadClass(loaderClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            loaderClass = Thread.currentThread().getContextClassLoader().loadClass(loaderClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return loaderClass;
    }

    private static DefaultPlexusContainer getContainerFromLookupLibrary(Class<?> loaderClass) {
        try {
            Field field = loaderClass.getDeclaredField("s_container");
            field.setAccessible(true);
            return (DefaultPlexusContainer)field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PlexusContainer getDefaultContainer() {
        DefaultContainerConfiguration configuration = new DefaultContainerConfiguration();
        configuration.setContainerConfiguration("/META-INF/plexus/plexus.xml");
        return ContainerLoader.getDefaultContainer((ContainerConfiguration)configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlexusContainer getDefaultContainer(ContainerConfiguration configuration) {
        if (s_container != null) return s_container;
        Class<?> loaderClass = ContainerLoader.findLoaderClass();
        Class<ContainerLoader> clazz = ContainerLoader.class;
        synchronized (ContainerLoader.class) {
            if (loaderClass != null) {
                s_container = ContainerLoader.getContainerFromLookupLibrary(loaderClass);
            }
            if (s_container != null) return s_container;
            try {
                ContainerLoader.preConstruction(configuration);
                s_container = new DefaultPlexusContainer(configuration);
                ContainerLoader.postConstruction(s_container);
                if (loaderClass == null) return s_container;
                ContainerLoader.setContainerToLookupLibrary(loaderClass, (PlexusContainer)s_container);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create Plexus container.", e);
            }
            return s_container;
        }
    }

    static <T> T lookupById(Class<T> role, String roleHint, String id) throws ComponentLookupException {
        Key key = new Key(role, roleHint, id);
        Object component = m_components.get(key);
        if (component == null && m_components.putIfAbsent(key, component = s_container.lookup(role, roleHint)) != null) {
            component = m_components.get(key);
        }
        return (T)component;
    }

    private static void postConstruction(DefaultPlexusContainer container) {
        container.getComponentRegistry().registerComponentManagerFactory((ComponentManagerFactory)new EnumComponentManagerFactory());
    }

    private static void preConstruction(ContainerConfiguration configuration) throws Exception {
        LifecycleHandler plexus = configuration.getLifecycleHandlerManager().getLifecycleHandler("plexus");
        Field field = Reflects.forField().getDeclaredField(AbstractLifecycleHandler.class, "beginSegment");
        field.setAccessible(true);
        List segment = (List)field.get(plexus);
        segment.add(0, new PostConstructionPhase());
        try {
            new ContainerConfigurationDecorator().process(configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setContainerToLookupLibrary(Class<?> loaderClass, PlexusContainer container) {
        try {
            Field field = loaderClass.getDeclaredField("s_container");
            field.setAccessible(true);
            field.set(null, container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        m_components = new ConcurrentHashMap<Key, Object>();
    }

    static class Key {
        private Class<?> m_role;
        private String m_roleHint;
        private String m_id;

        public Key(Class<?> role, String roleHint, String id) {
            this.m_role = role;
            this.m_roleHint = roleHint == null ? "default" : roleHint;
            this.m_id = id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key e = (Key)obj;
                if (e.m_role != this.m_role) {
                    return false;
                }
                if (!e.m_roleHint.equals(this.m_roleHint)) {
                    return false;
                }
                return e.m_id.equals(this.m_id);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = hashCode * 31 + this.m_role.hashCode();
            hashCode = hashCode * 31 + this.m_roleHint.hashCode();
            hashCode = hashCode * 31 + this.m_id.hashCode();
            return hashCode;
        }
    }

    static class ContainerConfigurationDecorator {
        private String m_defaultPath = "META-INF/plexus/plexus.xml";

        ContainerConfigurationDecorator() {
        }

        private void fillFrom(Document to, DocumentBuilder builder, URL url) throws Exception {
            InputStream in = url.openStream();
            Document from = builder.parse(in);
            in.close();
            Node source = from.getDocumentElement().getElementsByTagName("components").item(0);
            Node target = to.getDocumentElement().getFirstChild();
            NodeList list = source.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                target.appendChild(to.importNode(list.item(i), true));
            }
        }

        public void process(ContainerConfiguration configuration) throws Exception {
            Object url;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            String path = configuration.getContainerConfiguration();
            ClassRealm realm = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader()).getRealm("plexus.core");
            Enumeration resources = realm.getResources(this.m_defaultPath);
            Element root = doc.createElement("plexus");
            root.appendChild(doc.createElement("components"));
            doc.appendChild(root);
            doc.setXmlStandalone(true);
            if (path != null && !path.endsWith(this.m_defaultPath) && (url = realm.getResource(path)) != null) {
                this.fillFrom(doc, builder, (URL)url);
            }
            for (URL url2 : Collections.list(resources)) {
                this.fillFrom(doc, builder, url2);
            }
            if (doc.getDocumentElement().hasChildNodes()) {
                TransformerFactory transforerFactory = TransformerFactory.newInstance();
                Transformer transformer = transforerFactory.newTransformer();
                File tmp = File.createTempFile("plexus-", ".xml");
                StreamResult result = new StreamResult(new FileOutputStream(tmp));
                tmp.deleteOnExit();
                transformer.transform(new DOMSource(doc), result);
                configuration.setContainerConfigurationURL(tmp.toURI().toURL());
            }
        }
    }
}

