/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.codehaus.plexus.logging.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.unidal.helper.Threads;
import org.unidal.lookup.logger.LoggerFactory;
import org.unidal.net.SocketHandler;
import org.unidal.tuple.Pair;

class SocketClientManager {
    private static final ConcurrentMap<String, AtomicInteger> m_indexes = new ConcurrentHashMap<String, AtomicInteger>();
    private SocketHandler m_handler;
    private int m_maxThreads;
    private String m_threadNamePrefix;
    private FailoverChannelManager m_manager;
    private boolean m_active;
    private List<InetSocketAddress> m_serverAddresses = new ArrayList<InetSocketAddress>();
    private Logger m_logger = LoggerFactory.getLogger(SocketClientManager.class);
    private MessageSender m_sender;
    private int m_checkInterval;
    private String m_group;

    public SocketClientManager(SocketHandler handler, List<Integer> ports, List<String> servers) {
        this.m_handler = handler;
        int len = ports.size();
        for (int i = 0; i < len; ++i) {
            String server = servers.get(i);
            int port = ports.get(i);
            this.m_serverAddresses.add(new InetSocketAddress(server, port));
        }
    }

    private String getUniquePrefix() {
        String name;
        if (this.m_threadNamePrefix == null) {
            String className = new Exception().getStackTrace()[2].getClassName();
            int pos = className.lastIndexOf(46);
            name = className.substring(pos + 1);
        } else {
            name = this.m_threadNamePrefix;
        }
        m_indexes.putIfAbsent(name, new AtomicInteger(1));
        AtomicInteger index = (AtomicInteger)m_indexes.get(name);
        if (index.getAndIncrement() > 1) {
            name = name + index.get();
        }
        return name;
    }

    public void setCheckInterval(int checkInterval) {
        this.m_checkInterval = checkInterval;
    }

    public void setMaxThreads(int maxThreads) {
        this.m_maxThreads = maxThreads;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.m_threadNamePrefix = threadNamePrefix;
    }

    public void shutdown() {
        this.m_active = false;
        if (this.m_sender != null) {
            this.m_sender.shutdown();
        }
        this.m_manager.shutdown();
    }

    public void start() {
        this.m_group = this.getUniquePrefix();
        this.m_active = true;
        this.m_manager = new FailoverChannelManager();
        this.m_sender = new MessageSender();
        Threads.forGroup(this.m_group).start(this.m_manager);
        Thread thread = Threads.forGroup(this.m_group).start(this.m_sender);
        try {
            while (!thread.isAlive()) {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class MessageSender
    implements Threads.Task {
        private AtomicInteger m_attempts = new AtomicInteger();

        MessageSender() {
        }

        private boolean checkWritable(Channel channel) {
            boolean isWriteable = false;
            if (channel != null && channel.isOpen()) {
                if (channel.isWritable()) {
                    isWriteable = true;
                } else {
                    int count = this.m_attempts.incrementAndGet();
                    if (count % 1000 == 0 || count == 1) {
                        SocketClientManager.this.m_logger.error("Netty write buffer is full! Attempts: " + count + ".");
                    }
                }
            }
            return isWriteable;
        }

        @Override
        public String getName() {
            return this.getClass().getSimpleName();
        }

        @Override
        public void run() {
            try {
                while (SocketClientManager.this.m_active) {
                    Pair<Channel, ChannelBuffer> message = SocketClientManager.this.m_handler.getNextMessage();
                    if (message != null) {
                        Channel channel;
                        ChannelFuture future = SocketClientManager.this.m_manager.getChannelFuture();
                        Channel channel2 = channel = future == null ? null : future.getChannel();
                        if (channel != null && this.checkWritable(channel)) {
                            try {
                                channel.write((Object)message.getValue());
                            }
                            catch (Throwable t) {
                                SocketClientManager.this.m_logger.error("Error when sending message over TCP socket!", t);
                            }
                        }
                    }
                    TimeUnit.MILLISECONDS.sleep(5L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void shutdown() {
        }
    }

    class FailoverChannelManager
    implements Threads.Task {
        private ClientBootstrap m_bootstrap;
        private ChannelFuture m_activeFuture;
        private int m_activeIndex = -1;
        private ChannelFuture m_lastFuture;
        private AtomicInteger m_attempts = new AtomicInteger();
        private AtomicLong m_lastTime = new AtomicLong();

        public FailoverChannelManager() {
            this.m_bootstrap = this.setup(SocketClientManager.this.m_group);
            int len = SocketClientManager.this.m_serverAddresses.size();
            for (int i = 0; i < len; ++i) {
                ChannelFuture future = this.createChannel(i);
                if (future == null) continue;
                this.m_activeFuture = future;
                this.m_activeIndex = i;
                break;
            }
        }

        private ChannelFuture createChannel(int index) {
            InetSocketAddress address = (InetSocketAddress)SocketClientManager.this.m_serverAddresses.get(index);
            ChannelFuture future = this.m_bootstrap.connect((SocketAddress)address);
            future.awaitUninterruptibly(100L, TimeUnit.MILLISECONDS);
            if (!future.isSuccess()) {
                future.getChannel().close();
                int attempts = this.m_attempts.incrementAndGet();
                long lastTime = this.m_lastTime.get();
                long now = System.currentTimeMillis();
                if (attempts == 1 || attempts % 100 == 0 || lastTime < now - 60000L) {
                    this.m_lastTime.set(now);
                    SocketClientManager.this.m_logger.warn("Error when connecting to " + address + ", " + future.getCause() + ", attempts: " + attempts);
                }
                return null;
            }
            return future;
        }

        public ChannelFuture getChannelFuture() {
            if (this.m_lastFuture != null && this.m_lastFuture != this.m_activeFuture) {
                this.m_lastFuture.getChannel().close();
                this.m_lastFuture = null;
            }
            return this.m_activeFuture;
        }

        @Override
        public String getName() {
            return SocketClientManager.this.getClass().getSimpleName() + "-" + this.getClass().getSimpleName();
        }

        @Override
        public void run() {
            try {
                while (SocketClientManager.this.m_active) {
                    try {
                        if (this.m_activeIndex == -1 || this.m_activeFuture != null && !this.m_activeFuture.getChannel().isOpen()) {
                            this.m_activeIndex = SocketClientManager.this.m_serverAddresses.size();
                        }
                        for (int i = 0; i < this.m_activeIndex; ++i) {
                            ChannelFuture future = this.createChannel(i);
                            if (future == null) continue;
                            this.m_lastFuture = this.m_activeFuture;
                            this.m_activeFuture = future;
                            this.m_activeIndex = i;
                            break;
                        }
                    }
                    catch (Throwable e) {
                        SocketClientManager.this.m_logger.error("Error happened in ChannelManager.", e);
                    }
                    Thread.sleep(SocketClientManager.this.m_checkInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.shutdown();
        }

        private ClientBootstrap setup(String group) {
            NioClientSocketChannelFactory factory;
            ExecutorService bossExecutor;
            if (SocketClientManager.this.m_maxThreads > 0) {
                bossExecutor = Threads.forPool().getFixedThreadPool(group + "-Boss", 10);
                ExecutorService workerExecutor = Threads.forPool().getFixedThreadPool(group + "-Worker", SocketClientManager.this.m_maxThreads);
                factory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
            } else {
                bossExecutor = Threads.forPool().getCachedThreadPool(group + "-Boss");
                ExecutorService workerExecutor = Threads.forPool().getCachedThreadPool(group + "-Worker");
                factory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
            }
            ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)factory);
            bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() {
                    return Channels.pipeline((org.jboss.netty.channel.ChannelHandler[])new org.jboss.netty.channel.ChannelHandler[]{new ChannelHandler()});
                }
            });
            bootstrap.setOption("tcpNoDelay", (Object)true);
            bootstrap.setOption("keepAlive", (Object)true);
            bootstrap.setOption("connectTimeoutMillis", (Object)2000);
            return bootstrap;
        }

        @Override
        public void shutdown() {
            if (this.m_activeFuture != null) {
                this.m_activeFuture.getChannel().close().awaitUninterruptibly();
                this.m_activeFuture = null;
            }
            this.m_bootstrap.getFactory().releaseExternalResources();
        }
    }

    class ChannelHandler
    extends SimpleChannelHandler {
        ChannelHandler() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
            super.channelConnected(ctx, event);
            SocketClientManager.this.m_handler.onConnected(event.getChannel());
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
            super.channelDisconnected(ctx, event);
            SocketClientManager.this.m_handler.onDisconnected(event.getChannel());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
            SocketClientManager.this.m_handler.onException(event.getChannel(), event.getCause());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
            ChannelBuffer buffer = (ChannelBuffer)event.getMessage();
            SocketClientManager.this.m_handler.onMessage(event.getChannel(), buffer);
        }
    }
}

