/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.logging.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.unidal.helper.Threads;
import org.unidal.lookup.logger.LoggerFactory;
import org.unidal.net.SocketHandler;
import org.unidal.tuple.Pair;

class SocketServerManager {
    private static ConcurrentMap<String, AtomicInteger> m_indexes = new ConcurrentHashMap<String, AtomicInteger>();
    private SocketHandler m_handler;
    private InetSocketAddress m_bindAddress;
    private int m_maxThreads;
    private String m_threadNamePrefix;
    private ServerBootstrap m_bootstrap;
    private ChannelGroup m_channelGroup = new DefaultChannelGroup();
    private Logger m_logger = LoggerFactory.getLogger(SocketServerManager.class);
    private boolean m_active;
    private MessageSender m_sender;

    public SocketServerManager(SocketHandler handler, int port, String host) {
        this.m_handler = handler;
        this.m_threadNamePrefix = handler.getClass().getSimpleName();
        this.m_bindAddress = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
    }

    private String getUniquePrefix() {
        String name;
        if (this.m_threadNamePrefix == null) {
            String className = new Exception().getStackTrace()[2].getClassName();
            int pos = className.lastIndexOf(46);
            name = className.substring(pos + 1);
        } else {
            name = this.m_threadNamePrefix;
        }
        m_indexes.putIfAbsent(name, new AtomicInteger(1));
        AtomicInteger index = (AtomicInteger)m_indexes.get(name);
        if (index.getAndIncrement() > 1) {
            name = name + index.get();
        }
        return name;
    }

    public void setMaxThreads(int maxThreads) {
        this.m_maxThreads = maxThreads;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.m_threadNamePrefix = threadNamePrefix;
    }

    private ServerBootstrap setup(String group) {
        NioServerSocketChannelFactory factory;
        ExecutorService bossExecutor;
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ThreadNameDeterminer.CURRENT);
        if (this.m_maxThreads > 0) {
            bossExecutor = Threads.forPool().getFixedThreadPool(group + "-Boss-" + this.m_bindAddress, this.m_maxThreads);
            ExecutorService workerExecutor = Threads.forPool().getFixedThreadPool(group + "-Worker", this.m_maxThreads);
            factory = new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
        } else {
            bossExecutor = Threads.forPool().getCachedThreadPool(group + "-Boss-" + this.m_bindAddress);
            ExecutorService workerExecutor = Threads.forPool().getCachedThreadPool(group + "-Worker");
            factory = new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
        }
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                return Channels.pipeline((org.jboss.netty.channel.ChannelHandler[])new org.jboss.netty.channel.ChannelHandler[]{new ChannelDecoder(), new ChannelHandler()});
            }
        });
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        bootstrap.bind((SocketAddress)this.m_bindAddress);
        return bootstrap;
    }

    public void shutdown() {
        this.m_channelGroup.close().awaitUninterruptibly();
        this.m_bootstrap.getFactory().releaseExternalResources();
    }

    public void start() {
        String group = this.getUniquePrefix();
        this.m_active = true;
        this.m_bootstrap = this.setup(group);
        this.m_logger.info(this.m_threadNamePrefix + " is listening on " + this.m_bindAddress);
        this.m_sender = new MessageSender();
        Thread thread = Threads.forGroup(group).start(this.m_sender);
        try {
            while (!thread.isAlive()) {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class MessageSender
    implements Threads.Task {
        private AtomicInteger m_attempts = new AtomicInteger();

        MessageSender() {
        }

        private boolean checkWritable(Channel channel) {
            boolean isWriteable = false;
            if (channel != null && channel.isOpen()) {
                if (channel.isWritable()) {
                    isWriteable = true;
                } else {
                    int count = this.m_attempts.incrementAndGet();
                    if (count % 1000 == 0 || count == 1) {
                        SocketServerManager.this.m_logger.error("Netty write buffer is full! Attempts: " + count + ".");
                    }
                }
            }
            return isWriteable;
        }

        @Override
        public String getName() {
            return this.getClass().getSimpleName();
        }

        @Override
        public void run() {
            try {
                while (SocketServerManager.this.m_active) {
                    Channel channel;
                    Pair<Channel, ChannelBuffer> message = SocketServerManager.this.m_handler.getNextMessage();
                    if (message != null && (channel = message.getKey()) != null && this.checkWritable(channel)) {
                        try {
                            channel.write((Object)message.getValue());
                        }
                        catch (Throwable t) {
                            SocketServerManager.this.m_logger.error("Error when sending message over TCP socket!", t);
                        }
                    }
                    TimeUnit.MILLISECONDS.sleep(5L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void shutdown() {
        }
    }

    class ChannelHandler
    extends SimpleChannelHandler {
        ChannelHandler() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
            super.channelConnected(ctx, event);
            SocketServerManager.this.m_handler.onConnected(event.getChannel());
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
            super.channelDisconnected(ctx, event);
            SocketServerManager.this.m_handler.onDisconnected(event.getChannel());
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
            SocketServerManager.this.m_channelGroup.add((Object)event.getChannel());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
            SocketServerManager.this.m_handler.onException(event.getChannel(), event.getCause());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
            ChannelBuffer buffer = (ChannelBuffer)event.getMessage();
            SocketServerManager.this.m_handler.onMessage(event.getChannel(), buffer);
        }
    }

    static class ChannelDecoder
    extends FrameDecoder {
        ChannelDecoder() {
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) {
            int readableBytes = buffer.readableBytes();
            if (readableBytes < 4) {
                return null;
            }
            buffer.markReaderIndex();
            int length = buffer.readInt();
            buffer.resetReaderIndex();
            if (readableBytes < length + 4) {
                return null;
            }
            return buffer.readBytes(length + 4);
        }
    }
}

