/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo.dispatcher;

import cn.com.duiba.wolf.dubbo.dispatcher.RunInExecutor;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.ExecutionException;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.exchange.Request;
import com.alibaba.dubbo.remoting.transport.dispatcher.ChannelEventRunnable;
import com.alibaba.dubbo.remoting.transport.dispatcher.WrappedChannelHandler;
import com.alibaba.dubbo.rpc.Invocation;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingChannelHandler
extends WrappedChannelHandler {
    protected static final Logger log = LoggerFactory.getLogger(RoutingChannelHandler.class);
    private Map<String, ExecutorService> executorMap;

    public RoutingChannelHandler(ChannelHandler handler, URL url, Map<String, ExecutorService> executorMap) {
        super(handler, url);
        this.executorMap = executorMap;
    }

    public void connected(Channel channel) throws RemotingException {
        ExecutorService cexecutor = this.getExecutorService();
        try {
            cexecutor.execute((Runnable)new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.CONNECTED));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"connect event", channel, ((Object)((Object)this)).getClass() + " error when process connected event .", t);
        }
    }

    public void disconnected(Channel channel) throws RemotingException {
        ExecutorService cexecutor = this.getExecutorService();
        try {
            cexecutor.execute((Runnable)new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.DISCONNECTED));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"disconnect event", channel, ((Object)((Object)this)).getClass() + " error when process disconnected event .", t);
        }
    }

    public void received(Channel channel, Object message) throws RemotingException {
        ExecutorService cexecutor = this.getExecutorService(message);
        try {
            cexecutor.execute((Runnable)new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.RECEIVED, message));
        }
        catch (Throwable t) {
            throw new ExecutionException(message, channel, ((Object)((Object)this)).getClass() + " error when process received event .", t);
        }
    }

    public void caught(Channel channel, Throwable exception) throws RemotingException {
        ExecutorService cexecutor = this.getExecutorService();
        try {
            cexecutor.execute((Runnable)new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.CAUGHT, exception));
        }
        catch (Throwable t) {
            throw new ExecutionException((Object)"caught event", channel, ((Object)((Object)this)).getClass() + " error when process caught event .", t);
        }
    }

    private ExecutorService getExecutorService() {
        ExecutorService cexecutor = this.executor;
        if (cexecutor == null || cexecutor.isShutdown()) {
            cexecutor = SHARED_EXECUTOR;
        }
        return cexecutor;
    }

    private ExecutorService getExecutorService(Object message) {
        try {
            Object inv = message;
            if (message instanceof Request) {
                inv = ((Request)message).getData();
            }
            if (!(inv instanceof Invocation)) {
                return this.getExecutorService();
            }
            Invocation invocation = (Invocation)inv;
            String interfaceName = invocation.getAttachment("interface");
            Class<?> clazz = Class.forName(interfaceName);
            if (!clazz.isAnnotationPresent(RunInExecutor.class)) {
                return this.getExecutorService();
            }
            RunInExecutor annotation = clazz.getAnnotation(RunInExecutor.class);
            String executorKey = annotation.value();
            if ("default".equals(executorKey)) {
                return this.getExecutorService();
            }
            ExecutorService executor = this.executorMap.get(executorKey);
            if (executor != null) {
                if (log.isDebugEnabled()) {
                    log.debug(interfaceName + "." + invocation.getMethodName() + " run in executor:" + executorKey);
                }
                return executor;
            }
            log.error("warn: threadPool of key:[" + executorKey + "] not exists in springContext, will use default");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.getExecutorService();
    }
}

