/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat;

import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.ForkedTransaction;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.MessageProducer;
import com.dianping.cat.message.TaggedTransaction;
import com.dianping.cat.message.Trace;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageManager;
import com.dianping.cat.message.spi.MessageTree;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.unidal.helper.Files;
import org.unidal.helper.Properties;
import org.unidal.initialization.DefaultModuleContext;
import org.unidal.initialization.Module;
import org.unidal.initialization.ModuleContext;
import org.unidal.initialization.ModuleInitializer;
import org.unidal.lookup.ContainerLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cat {
    private static Cat s_instance = new Cat();
    private static volatile boolean s_init = false;
    private MessageProducer m_producer;
    private MessageManager m_manager;
    private PlexusContainer m_container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndInitialize() {
        if (!s_init) {
            Cat cat = s_instance;
            synchronized (cat) {
                if (!s_init) {
                    Cat.initialize(new File(Cat.getCatHome(), "client.xml"));
                    Cat.log("WARN", "Cat is lazy initialized!");
                    s_init = true;
                }
            }
        }
    }

    public static String createMessageId() {
        return Cat.getProducer().createMessageId();
    }

    public static void destroy() {
        Cat.s_instance.m_container.dispose();
        s_instance = new Cat();
    }

    public static String getCatHome() {
        String catHome = (String)Properties.forString().fromEnv().fromSystem().getProperty("CAT_HOME", (Object)"/data/appdatas/cat");
        return catHome;
    }

    public static String getCurrentMessageId() {
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        if (tree != null) {
            String messageId = tree.getMessageId();
            if (messageId == null) {
                messageId = Cat.createMessageId();
                tree.setMessageId(messageId);
            }
            return messageId;
        }
        return null;
    }

    public static Cat getInstance() {
        return s_instance;
    }

    public static MessageManager getManager() {
        Cat.checkAndInitialize();
        return Cat.s_instance.m_manager;
    }

    public static MessageProducer getProducer() {
        Cat.checkAndInitialize();
        return Cat.s_instance.m_producer;
    }

    public static void initialize(File configFile) {
        PlexusContainer container = ContainerLoader.getDefaultContainer();
        Cat.initialize(container, configFile);
    }

    public static void initialize(PlexusContainer container, File configFile) {
        DefaultModuleContext ctx = new DefaultModuleContext(container);
        Module module = (Module)ctx.lookup(Module.class, "cat-client");
        if (!module.isInitialized()) {
            ModuleInitializer initializer = (ModuleInitializer)ctx.lookup(ModuleInitializer.class);
            ctx.setAttribute("cat-client-config-file", (Object)configFile);
            initializer.execute((ModuleContext)ctx, new Module[]{module});
        }
    }

    public static void initialize(String ... servers) {
        File configFile = null;
        try {
            configFile = File.createTempFile("cat-client", ".xml");
            ClientConfig config = new ClientConfig().setMode("client");
            for (String server : servers) {
                config.addServer(new Server(server));
            }
            Files.forIO().writeTo(configFile, config.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Cat.initialize(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Cat cat = s_instance;
        synchronized (cat) {
            return Cat.s_instance.m_container != null;
        }
    }

    static void log(String severity, String message) {
        MessageFormat format = new MessageFormat("[{0,date,MM-dd HH:mm:ss.sss}] [{1}] [{2}] {3}");
        System.out.println(format.format(new Object[]{new Date(), severity, "cat", message}));
    }

    public static void logError(String message, Throwable cause) {
        Cat.getProducer().logError(message, cause);
    }

    public static void logError(Throwable cause) {
        Cat.getProducer().logError(cause);
    }

    public static void logEvent(String type, String name) {
        Cat.getProducer().logEvent(type, name);
    }

    public static void logEvent(String type, String name, String status, String nameValuePairs) {
        Cat.getProducer().logEvent(type, name, status, nameValuePairs);
    }

    public static void logHeartbeat(String type, String name, String status, String nameValuePairs) {
        Cat.getProducer().logHeartbeat(type, name, status, nameValuePairs);
    }

    public static void logMetric(String name, Object ... keyValues) {
    }

    public static void logMetricForCount(String name) {
        Cat.logMetricInternal(name, "C", "1");
    }

    public static void logMetricForCount(String name, int quantity) {
        Cat.logMetricInternal(name, "C", String.valueOf(quantity));
    }

    public static void logMetricForDuration(String name, long durationInMillis) {
        Cat.logMetricInternal(name, "T", String.valueOf(durationInMillis));
    }

    public static void logMetricForSum(String name, double value) {
        Cat.logMetricInternal(name, "S", String.format("%.2f", value));
    }

    public static void logMetricForSum(String name, double sum, int quantity) {
        Cat.logMetricInternal(name, "S,C", String.format("%s,%.2f", quantity, sum));
    }

    private static void logMetricInternal(String name, String status, String keyValuePairs) {
        Cat.getProducer().logMetric(name, status, keyValuePairs);
    }

    public static void logRemoteCallClient(Context ctx) {
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        String messageId = tree.getMessageId();
        if (messageId == null) {
            messageId = Cat.createMessageId();
            tree.setMessageId(messageId);
        }
        String childId = Cat.createMessageId();
        Cat.logEvent("RemoteCall", "", "0", childId);
        String root = tree.getRootMessageId();
        if (root == null) {
            root = messageId;
        }
        ctx.addProperty("_catRootMessageId", root);
        ctx.addProperty("_catParentMessageId", messageId);
        ctx.addProperty("_catChildMessageId", childId);
    }

    public static void logRemoteCallServer(Context ctx) {
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        String messageId = ctx.getProperty("_catChildMessageId");
        String rootId = ctx.getProperty("_catRootMessageId");
        String parentId = ctx.getProperty("_catParentMessageId");
        if (messageId != null) {
            tree.setMessageId(messageId);
        }
        if (parentId != null) {
            tree.setParentMessageId(parentId);
        }
        if (rootId != null) {
            tree.setRootMessageId(rootId);
        }
    }

    public static void logTrace(String type, String name) {
        Cat.getProducer().logTrace(type, name);
    }

    public static void logTrace(String type, String name, String status, String nameValuePairs) {
        Cat.getProducer().logTrace(type, name, status, nameValuePairs);
    }

    public static <T> T lookup(Class<T> role) throws ComponentLookupException {
        return Cat.lookup(role, null);
    }

    public static <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return (T)Cat.s_instance.m_container.lookup(role, hint);
    }

    public static Event newEvent(String type, String name) {
        return Cat.getProducer().newEvent(type, name);
    }

    public static ForkedTransaction newForkedTransaction(String type, String name) {
        return Cat.getProducer().newForkedTransaction(type, name);
    }

    public static Heartbeat newHeartbeat(String type, String name) {
        return Cat.getProducer().newHeartbeat(type, name);
    }

    public static TaggedTransaction newTaggedTransaction(String type, String name, String tag) {
        return Cat.getProducer().newTaggedTransaction(type, name, tag);
    }

    public static Trace newTrace(String type, String name) {
        return Cat.getProducer().newTrace(type, name);
    }

    public static Transaction newTransaction(String type, String name) {
        return Cat.getProducer().newTransaction(type, name);
    }

    public static void reset() {
    }

    public static void setup(String sessionToken) {
        Cat.getManager().setup();
    }

    private Cat() {
    }

    void setContainer(PlexusContainer container) {
        try {
            this.m_container = container;
            this.m_manager = (MessageManager)container.lookup(MessageManager.class);
            this.m_producer = (MessageProducer)container.lookup(MessageProducer.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Unable to get instance of MessageManager, please make sure the environment was setup correctly!", e);
        }
    }

    public static interface Context {
        public static final String ROOT = "_catRootMessageId";
        public static final String PARENT = "_catParentMessageId";
        public static final String CHILD = "_catChildMessageId";

        public void addProperty(String var1, String var2);

        public String getProperty(String var1);
    }
}

