/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.ClientConfigMerger;
import com.dianping.cat.configuration.ClientConfigValidator;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.DefaultSaxParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClientConfigManager
implements LogEnabled,
ClientConfigManager,
Initializable {
    private static final String CAT_CLIENT_XML = "/META-INF/cat/client.xml";
    private static final String PROPERTIES_CLIENT_XML = "/META-INF/app.properties";
    private static final String CLIENT_XML = "/META-INF/client.xml";
    private static final String XML = "/data/appdatas/cat/client.xml";
    private Logger m_logger;
    private ClientConfig m_config;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public Domain getDomain() {
        Domain domain = null;
        if (this.m_config != null) {
            Map<String, Domain> domains = this.m_config.getDomains();
            Domain domain2 = domain = domains.isEmpty() ? null : domains.values().iterator().next();
        }
        if (domain != null) {
            return domain;
        }
        return new Domain("UNKNOWN").setEnabled(false);
    }

    @Override
    public int getMaxMessageLength() {
        if (this.m_config == null) {
            return 5000;
        }
        return this.getDomain().getMaxMessageSize();
    }

    @Override
    public String getServerConfigUrl() {
        if (this.m_config == null) {
            return null;
        }
        List<Server> servers = this.m_config.getServers();
        Iterator<Server> i$ = servers.iterator();
        if (i$.hasNext()) {
            Server server = i$.next();
            Integer httpPort = server.getHttpPort();
            if (httpPort == null || httpPort == 0) {
                httpPort = 8080;
            }
            return String.format("http://%s:%d/cat/s/router?domain=%s&ip=%s&op=json", server.getIp().trim(), httpPort, this.getDomain().getId(), NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        }
        return null;
    }

    @Override
    public List<Server> getServers() {
        if (this.m_config == null) {
            return Collections.emptyList();
        }
        return this.m_config.getServers();
    }

    @Override
    public int getTaggedTransactionCacheSize() {
        return 1024;
    }

    @Override
    public boolean isCatEnabled() {
        if (this.m_config == null) {
            return false;
        }
        return this.m_config.isEnabled();
    }

    @Override
    public boolean isDumpLocked() {
        if (this.m_config == null) {
            return false;
        }
        return this.m_config.isDumpLocked();
    }

    private ClientConfig loadConfigFromEnviroment() {
        String appName = this.loadProjectName();
        if (appName != null) {
            ClientConfig config = new ClientConfig();
            config.addDomain(new Domain(appName));
            return config;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConfig loadConfigFromXml() {
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CAT_CLIENT_XML);
            if (in == null) {
                in = Cat.class.getResourceAsStream(CAT_CLIENT_XML);
            }
            if (in != null) {
                String xml = Files.forIO().readFrom(in, "utf-8");
                this.m_logger.info(String.format("Resource file(%s) found.", Cat.class.getResource(CAT_CLIENT_XML)));
                ClientConfig clientConfig = DefaultSaxParser.parse(xml);
                return clientConfig;
            }
            ClientConfig xml = null;
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadProjectName() {
        String appName = null;
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES_CLIENT_XML);
            if (in == null) {
                in = Cat.class.getResourceAsStream(PROPERTIES_CLIENT_XML);
            }
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                appName = prop.getProperty("app.name");
                if (appName == null) {
                    this.m_logger.info(String.format("Can't find app.name from app.properties.", new Object[0]));
                    String string = null;
                    return string;
                }
                this.m_logger.info(String.format("Find domain name %s from app.properties.", appName));
            } else {
                this.m_logger.info(String.format("Can't find app.properties in %s", PROPERTIES_CLIENT_XML));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return appName;
    }

    public void initialize() throws InitializationException {
        File configFile = new File(XML);
        this.initialize(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyClientFile() {
        InputStream in = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            File clientFile = new File(XML);
            if (!clientFile.exists()) {
                File filePath = new File("/data/appdatas/cat");
                filePath.mkdirs();
                in = Cat.class.getResourceAsStream(CLIENT_XML);
                if (in != null) {
                    br = new BufferedReader(new InputStreamReader(in, "utf-8"));
                    bw = new BufferedWriter(new FileWriter(XML));
                    String str = null;
                    while ((str = br.readLine()) != null) {
                        bw.write(str + "\n");
                    }
                    bw.flush();
                } else {
                    this.m_logger.info(String.format("Can't find client.xml in %s", CLIENT_XML));
                }
            }
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void initialize(File configFile) throws InitializationException {
        try {
            ClientConfig globalConfig = null;
            ClientConfig clientConfig = null;
            if (configFile != null) {
                if (configFile.exists()) {
                    String xml = Files.forIO().readFrom(configFile.getCanonicalFile(), "utf-8");
                    globalConfig = DefaultSaxParser.parse(xml);
                    this.m_logger.info(String.format("Global config file(%s) found.", configFile));
                } else {
                    this.m_logger.warn(String.format("Global config file(%s) not found, IGNORED.", configFile));
                }
            }
            if ((clientConfig = this.loadConfigFromEnviroment()) == null) {
                clientConfig = this.loadConfigFromXml();
            }
            if (globalConfig != null && clientConfig != null) {
                globalConfig.accept(new ClientConfigMerger(clientConfig));
            }
            if (clientConfig != null) {
                clientConfig.accept(new ClientConfigValidator());
            }
            this.m_config = clientConfig;
        }
        catch (Exception e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
    }
}

