/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.io;

import com.dianping.cat.message.spi.MessageQueue;
import com.dianping.cat.message.spi.MessageTree;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultMessageQueue
implements MessageQueue {
    private BlockingQueue<MessageTree> m_queue;
    private AtomicInteger m_count = new AtomicInteger();

    public DefaultMessageQueue(int size) {
        this.m_queue = new LinkedBlockingQueue<MessageTree>(size);
    }

    public boolean offer(MessageTree tree) {
        return this.m_queue.offer(tree);
    }

    public boolean offer(MessageTree tree, double sampleRatio) {
        if (tree.isSample() && sampleRatio < 1.0) {
            int count;
            if (sampleRatio > 0.0 && (double)(count = this.m_count.incrementAndGet()) % (1.0 / sampleRatio) == 0.0) {
                return this.offer(tree);
            }
            return false;
        }
        return this.offer(tree);
    }

    public MessageTree peek() {
        return (MessageTree)this.m_queue.peek();
    }

    public MessageTree poll() {
        try {
            return this.m_queue.poll(5L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public int size() {
        return this.m_queue.size();
    }
}

