/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.auth;

import com.taobao.top.link.embedded.websocket.HttpHeader;
import com.taobao.top.link.embedded.websocket.WebSocket;
import com.taobao.top.link.embedded.websocket.auth.AuthScheme;
import com.taobao.top.link.embedded.websocket.auth.Authenticator;
import com.taobao.top.link.embedded.websocket.auth.Challenge;
import com.taobao.top.link.embedded.websocket.auth.Credentials;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import com.taobao.top.link.embedded.websocket.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticator
implements Authenticator {
    protected WebSocket websocket;
    protected Credentials credentials;
    private boolean isDone = false;

    @Override
    public String getCredentials(String method, String requestUri, HttpHeader header, String authenticateHeaderName) throws WebSocketException {
        if (this.isDone) {
            throw new IllegalStateException("this Authenticator already executed");
        }
        List<String> proxyAuthenticateList = header.getHeaderValues(authenticateHeaderName);
        ArrayList<Challenge> challengeList = new ArrayList<Challenge>();
        for (String proxyAuthenticateStr : proxyAuthenticateList) {
            String[] parts = proxyAuthenticateStr.split(" +", 2);
            AuthScheme authScheme = null;
            try {
                authScheme = AuthScheme.valueOf(parts[0]);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            String param = null;
            if (parts.length > 1) {
                param = parts[1];
            }
            challengeList.add(new Challenge(method, requestUri, authScheme, param));
        }
        return this.getCredentials(challengeList);
    }

    public abstract String getCredentials(List<Challenge> var1) throws WebSocketException;

    @Override
    public void init(WebSocket websocket, Credentials credentials) {
        if (this.isDone) {
            throw new IllegalStateException("this Authenticator already executed");
        }
        this.websocket = websocket;
        this.credentials = credentials;
    }

    protected void parseParams(Map<String, String> paramMap, String authParams) {
        paramMap.putAll(StringUtil.parseKeyValues(authParams, ','));
    }

    @Override
    public void done() {
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isNeedAuthenticate() {
        return true;
    }
}

