/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.handshake;

import com.taobao.top.link.embedded.websocket.BufferManager;
import com.taobao.top.link.embedded.websocket.WebSocket;
import com.taobao.top.link.embedded.websocket.auth.Authenticator;
import com.taobao.top.link.embedded.websocket.exception.ErrorCode;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import com.taobao.top.link.embedded.websocket.handshake.HttpResponseHeaderParser;
import com.taobao.top.link.embedded.websocket.util.PacketDumpUtil;
import com.taobao.top.link.embedded.websocket.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.EnumMap;
import java.util.EnumSet;

public class ProxyHandshake {
    private static String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    private final InetSocketAddress proxyAddress;
    private final InetSocketAddress originAddress;
    private int connectionReadTimeout = 0;
    private boolean needAuthorize;
    private Authenticator authenticator;
    private Selector selector;
    private HttpResponseHeaderParser httpResponseHeaderParser;
    private WebSocket webSocket;
    private volatile State state = State.INIT;

    protected State transitionTo(State to) {
        if (this.state.canTransitionTo(to)) {
            State old = this.state;
            this.state = to;
            return old;
        }
        throw new IllegalStateException("Couldn't transtion from " + (Object)((Object)this.state) + " to " + (Object)((Object)to));
    }

    protected State state() {
        return this.state;
    }

    public ProxyHandshake(InetSocketAddress proxy, InetSocketAddress origin, WebSocket webSocket) {
        this.proxyAddress = proxy;
        this.originAddress = origin;
        this.webSocket = webSocket;
    }

    public ProxyHandshake(InetSocketAddress proxy, InetSocketAddress origin, Authenticator authenticator, WebSocket webSocket) {
        this.proxyAddress = proxy;
        this.originAddress = origin;
        this.authenticator = authenticator;
        this.webSocket = webSocket;
    }

    public void doHandshake(SocketChannel socket) throws WebSocketException {
        try {
            BufferManager bufferManager = new BufferManager();
            this.httpResponseHeaderParser = new HttpResponseHeaderParser();
            this.selector = Selector.open();
            socket.register(this.selector, 1);
            String method = "CONNECT";
            String host = this.originAddress.getHostName() + ":" + this.originAddress.getPort();
            ByteBuffer request = this.createHandshakeRequest(method, host);
            if (PacketDumpUtil.isDump(this.webSocket, 8)) {
                PacketDumpUtil.printPacketDump("PROXY_HS_UP", request);
            }
            socket.write(request);
            this.transitionTo(State.METHOD);
            ByteBuffer responseBuffer = ByteBuffer.allocate(8192);
            String creadectialsStr = null;
            boolean completed = false;
            do {
                this.selector.select(this.connectionReadTimeout);
                responseBuffer.clear();
                socket.read(responseBuffer);
                responseBuffer.flip();
                if (PacketDumpUtil.isDump(this.webSocket, 2)) {
                    PacketDumpUtil.printPacketDump("PROXY_HS_DOWN", responseBuffer);
                }
                responseBuffer = bufferManager.getBuffer(responseBuffer);
                switch (this.state) {
                    case METHOD: 
                    case HEADER: {
                        this.needAuthorize = false;
                        completed = this.parseHandshakeResponseHeader(responseBuffer);
                        if (!completed) {
                            bufferManager.storeFragmentBuffer(responseBuffer);
                            break;
                        }
                        if (this.needAuthorize) {
                            if (!this.authenticator.isNeedAuthenticate()) {
                                throw new WebSocketException(ErrorCode.E3200);
                            }
                            if (this.authenticator == null) {
                                throw new WebSocketException(ErrorCode.E3201);
                            }
                            creadectialsStr = this.authenticator.getCredentials(method, host, this.httpResponseHeaderParser.getResponseHeader(), PROXY_AUTHENTICATE);
                            if (creadectialsStr != null) {
                                this.transitionTo(State.AUTH);
                                socket.register(this.selector, 4);
                                break;
                            }
                            throw new WebSocketException(ErrorCode.E3202);
                        }
                        this.transitionTo(State.DONE);
                        break;
                    }
                    case AUTH: {
                        ByteBuffer buffer = this.createAuthorizeRequest(creadectialsStr);
                        if (PacketDumpUtil.isDump(this.webSocket, 8)) {
                            PacketDumpUtil.printPacketDump("PROXY_HS_UP", buffer);
                        }
                        socket.write(buffer);
                        this.httpResponseHeaderParser = new HttpResponseHeaderParser();
                        this.transitionTo(State.METHOD);
                        socket.register(this.selector, 1);
                        break;
                    }
                }
            } while (this.state != State.DONE);
        }
        catch (IOException ioe) {
            throw new WebSocketException(ErrorCode.E3100, (Throwable)ioe);
        }
        finally {
            try {
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public ByteBuffer createHandshakeRequest(String method, String host) {
        StringBuilder sb = new StringBuilder();
        sb.append(method + " " + host + " HTTP/1.1\r\n");
        StringUtil.addHeader(sb, "Host", host);
        sb.append("\r\n");
        try {
            return ByteBuffer.wrap(sb.toString().getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public ByteBuffer createAuthorizeRequest(String creadectialsStr) {
        StringBuilder sb = new StringBuilder();
        String host = this.originAddress.getHostName() + ":" + this.originAddress.getPort();
        sb.append("CONNECT " + host + " HTTP/1.1\r\n");
        StringUtil.addHeader(sb, "Host", host);
        StringUtil.addHeader(sb, "Proxy-Authorization", creadectialsStr);
        sb.append("\r\n");
        try {
            return ByteBuffer.wrap(sb.toString().getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    protected boolean parseHandshakeResponseHeader(ByteBuffer buffer) throws WebSocketException {
        if (this.state == State.METHOD) {
            String line = StringUtil.readLine(buffer);
            if (line == null) {
                return false;
            }
            if (!line.startsWith("HTTP/1.0") && !line.startsWith("HTTP/1.1")) {
                throw new WebSocketException(ErrorCode.E3101, line);
            }
            int responseStatus = Integer.valueOf(line.substring(9, 12));
            if (responseStatus != 200) {
                if (responseStatus == 407) {
                    this.needAuthorize = true;
                } else {
                    throw new WebSocketException(ErrorCode.E3102, line);
                }
            }
            this.transitionTo(State.HEADER);
        }
        if (this.state == State.HEADER) {
            this.httpResponseHeaderParser.parse(buffer);
            return this.httpResponseHeaderParser.isCompleted();
        }
        return true;
    }

    public int getConnectionReadTimeout() {
        return this.connectionReadTimeout;
    }

    public void setConnectionReadTimeout(int connectionReadTimeout) {
        this.connectionReadTimeout = connectionReadTimeout;
    }

    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public InetSocketAddress getOriginAddress() {
        return this.originAddress;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INIT,
        METHOD,
        HEADER,
        AUTH,
        DONE;

        private static EnumMap<State, EnumSet<State>> stateMap;

        boolean canTransitionTo(State state) {
            EnumSet<State> set = stateMap.get((Object)this);
            if (set == null) {
                return false;
            }
            return set.contains((Object)state);
        }

        static {
            stateMap = new EnumMap(State.class);
            stateMap.put(INIT, EnumSet.of(METHOD));
            stateMap.put(METHOD, EnumSet.of(HEADER));
            stateMap.put(HEADER, EnumSet.of(AUTH, DONE));
            stateMap.put(AUTH, EnumSet.of(METHOD));
            stateMap.put(DONE, EnumSet.of(METHOD));
        }
    }
}

