/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortService;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivitySortServiceImpl
extends BaseRemoteService
implements RemoteActivitySortService {
    @Autowired
    private ActivitySortService activitySortService;
    @Autowired
    private ActivitySpmService activitySpmService;
    @Autowired
    private ActivityService activityService;

    public DubboResult<List<RspActivityDto>> getActivityForCenter(Long slotId) {
        try {
            return DubboResult.successResult(this.activitySortService.getActivityForCenter(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortService.getActivityForCenter is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> getActivityIdForCenter(int count) {
        try {
            return DubboResult.successResult(this.activitySpmService.getTuiaActivityIdList(count));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortService.getActivityIdForCenter is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityBySlotNew(Long slotId) {
        try {
            return DubboResult.successResult(this.activitySortService.getActivityForRecommendBySlot(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityBySlotNew is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getEngineActivityList() {
        try {
            return DubboResult.successResult(this.activitySortService.getEngineActivityList());
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getEngineActivityList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getNewActivityList() {
        try {
            return DubboResult.successResult(this.activitySortService.getNewActivityList());
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getNewActivityList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getDefaultActivityList() {
        try {
            return DubboResult.successResult(this.activitySortService.getDefaultActivityList());
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getDefaultActivityList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityPlanDetailList(List<Long> ids) {
        try {
            List<RspActivityDto> activityList = this.activityService.getActivityByIds(ids, null);
            for (RspActivityDto activityDto : activityList) {
                this.activityService.getMsItemContent(activityDto);
            }
            return DubboResult.successResult(activityList);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityPlanDetailList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

