/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteTuiaActivityService;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityAdvertService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityDirectAppCacheService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RemoteTuiaActivityServiceImpl
extends BaseRemoteService
implements RemoteTuiaActivityService {
    @Autowired
    private ActivitySpmService activitySpmService;
    @Autowired
    private ActivityAdvertService activityAdvertService;
    @Autowired
    private ActivityDirectAppCacheService activityDirectAppCacheService;
    @Autowired
    private MediaAppService mediaAppService;
    @Autowired
    private ActivityService activityService;

    public DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer source) {
        try {
            List<Long> list = this.activityDirectAppCacheService.getBySource(activityId, source);
            ArrayList<MediaAppDto> result = new ArrayList<MediaAppDto>();
            if (!CollectionUtils.isEmpty(list)) {
                List<IdAndName> apps = this.mediaAppService.selectAppIdAndName(list);
                for (IdAndName idAndName : apps) {
                    result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
                }
            }
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityDirectedMediaAppBySource is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspActivityDto> getActivityPlan(Long activityId, Integer source) {
        try {
            return DubboResult.successResult((Object)this.activityService.getActivityPlanDetailBySource(activityId, source));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer source) {
        try {
            return DubboResult.successResult(this.activityAdvertService.getActivityAdvertIdsBySource(activityId, source));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityAdvertIds is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<ActivitySpmDto>> getSlotSpm(Long slotId, Integer statType) {
        try {
            return DubboResult.successResult(this.activitySpmService.getSlotSpm(slotId, statType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getSlotSpm is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> removeFromNewActList(Long activityId, Integer source) {
        try {
            return DubboResult.successResult((Object)this.activityService.changeToOldActBySource(activityId, source));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.removeFromNewActListBySource is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer source) {
        try {
            RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetailBySource(activityId, source);
            rspActivityDto = this.activityService.getMsItemContent(rspActivityDto);
            return DubboResult.successResult((Object)rspActivityDto);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityBackendService.getActivityPlanDetailBySource is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

