/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.MediaAppActivityDAO;
import cn.com.duiba.tuia.media.dataobject.MediaAppActivityDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.MediaAppActivityService;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityDirectAppCacheService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="mediaAppActivityService")
public class MediaAppActivityServiceImpl
implements MediaAppActivityService {
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private MediaAppActivityDAO mediaAppActivityDAO;
    @Autowired
    private ActivityDirectAppCacheService activityDirectAppCacheService;

    @Override
    public Boolean activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, List<Long> appIds) throws TuiaMediaException {
        if (1 != directStatus && 0 != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsDirectMedia(directStatus);
        this.activityDAO.update(activityDto);
        this.mediaAppActivityDAO.delete(activityId, activityType);
        if (!CollectionUtils.isEmpty(appIds)) {
            ArrayList<MediaAppActivityDO> list = new ArrayList<MediaAppActivityDO>(appIds.size());
            for (Long appId : appIds) {
                MediaAppActivityDO mediaAppActivityDO = new MediaAppActivityDO();
                mediaAppActivityDO.setActivityId(activityId);
                mediaAppActivityDO.setActivityType(activityType);
                mediaAppActivityDO.setMediaAppId(appId);
                list.add(mediaAppActivityDO);
            }
            this.mediaAppActivityDAO.insertBatch(list);
            this.activityDirectAppCacheService.set(activityId, activityType, appIds);
        }
        return true;
    }

    @Override
    public Boolean activityDirectToMediaAppBySource(Long activityId, Integer activityType, Integer source, Integer directStatus, List<Long> appIds) throws TuiaMediaException {
        if (1 != directStatus && 0 != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setSource(source);
        activityDto.setIsDirectMedia(directStatus);
        this.activityDAO.update(activityDto);
        this.mediaAppActivityDAO.deleteBySource(activityId, source);
        if (!CollectionUtils.isEmpty(appIds)) {
            ArrayList<MediaAppActivityDO> list = new ArrayList<MediaAppActivityDO>(appIds.size());
            for (Long appId : appIds) {
                MediaAppActivityDO mediaAppActivityDO = new MediaAppActivityDO();
                mediaAppActivityDO.setActivityId(activityId);
                mediaAppActivityDO.setActivityType(activityType);
                mediaAppActivityDO.setSource(source);
                mediaAppActivityDO.setMediaAppId(appId);
                list.add(mediaAppActivityDO);
            }
            this.mediaAppActivityDAO.insertBatch(list);
            this.activityDirectAppCacheService.setBySource(activityId, source, appIds);
        }
        return true;
    }
}

