/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.ServiceCredentials;
import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.comm.DefaultServiceClient;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.internal.CORSOperation;
import com.aliyun.oss.internal.OSSBucketOperation;
import com.aliyun.oss.internal.OSSMultipartOperation;
import com.aliyun.oss.internal.OSSObjectOperation;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.SignUtils;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListMultipartUploadsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.OptionsRequest;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSSClient
implements OSS {
    private ServiceCredentials credentials = new ServiceCredentials();
    private URI endpoint;
    private ServiceClient serviceClient;
    private OSSBucketOperation bucketOperation;
    private OSSObjectOperation objectOperation;
    private OSSMultipartOperation multipartOperation;
    private CORSOperation corsOperation;

    public OSSClient(String accessKeyId, String accessKeySecret) {
        this("http://oss.aliyuncs.com", accessKeyId, accessKeySecret, null);
    }

    public OSSClient(String endpoint, String accessKeyId, String accessKeySecret) {
        this(endpoint, accessKeyId, accessKeySecret, null);
    }

    public OSSClient(String endpoint, String accessKeyId, String accessKeySecret, ClientConfiguration config) {
        CodingUtils.assertStringNotNullOrEmpty(endpoint, "endpoint");
        try {
            if (!endpoint.startsWith("http://")) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("EndpointProtocolInvalid"));
            }
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.credentials = new ServiceCredentials(accessKeyId, accessKeySecret);
        this.serviceClient = new DefaultServiceClient(config != null ? config : new ClientConfiguration());
        this.bucketOperation = new OSSBucketOperation(this.endpoint, this.serviceClient, this.credentials);
        this.objectOperation = new OSSObjectOperation(this.endpoint, this.serviceClient, this.credentials);
        this.multipartOperation = new OSSMultipartOperation(this.endpoint, this.serviceClient, this.credentials);
        this.corsOperation = new CORSOperation(this.endpoint, this.serviceClient, this.credentials);
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKeyId() {
        return this.credentials.getAccessKeyId();
    }

    public String getAccessKeySecret() {
        return this.credentials.getAccessKeySecret();
    }

    @Override
    public Bucket createBucket(String bucketName) throws OSSException, ClientException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) {
        return this.bucketOperation.createBucket(createBucketRequest);
    }

    @Override
    public void deleteBucket(String bucketName) throws OSSException, ClientException {
        this.bucketOperation.deleteBucket(bucketName);
    }

    @Override
    public List<Bucket> listBuckets() throws OSSException, ClientException {
        return this.bucketOperation.listBuckets();
    }

    @Override
    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws OSSException, ClientException {
        this.bucketOperation.setBucketAcl(bucketName, acl);
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws OSSException, ClientException {
        return this.bucketOperation.getBucketAcl(bucketName);
    }

    @Override
    public String getBucketLocation(String bucketName) throws OSSException, ClientException {
        return this.bucketOperation.getBucketLocation(bucketName);
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws OSSException, ClientException {
        return this.bucketOperation.bucketExists(bucketName);
    }

    @Deprecated
    public boolean isBucketExist(String bucketName) throws OSSException, ClientException {
        return this.doesBucketExist(bucketName);
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws OSSException, ClientException {
        return this.listObjects(new ListObjectsRequest(bucketName, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String bucketName, String prefix) throws OSSException, ClientException {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws OSSException, ClientException {
        return this.bucketOperation.listObjects(listObjectsRequest);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws OSSException, ClientException {
        return this.objectOperation.putObject(bucketName, key, input, metadata);
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws OSSException, ClientException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.copyObject(copyObjectRequest);
    }

    @Override
    public OSSObject getObject(String bucketName, String key) throws OSSException, ClientException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) throws OSSException, ClientException {
        return this.objectOperation.getObject(getObjectRequest, file);
    }

    @Override
    public OSSObject getObject(GetObjectRequest getObjectRequest) throws OSSException, ClientException {
        return this.objectOperation.getObject(getObjectRequest);
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws OSSException, ClientException {
        return this.objectOperation.getObjectMetadata(bucketName, key);
    }

    @Override
    public void deleteObject(String bucketName, String key) throws OSSException, ClientException {
        this.objectOperation.deleteObject(bucketName, key);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws ClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethod.GET);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method) throws ClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key);
        request.setExpiration(expiration);
        request.setMethod(method);
        return this.generatePresignedUrl(request);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest request) throws ClientException {
        String queryString;
        CodingUtils.assertParameterNotNull(request, "request");
        if (request.getBucketName() == null) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetBucketName"));
        }
        OSSUtils.ensureBucketNameValid(request.getBucketName());
        if (request.getExpiration() == null) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetExpiration"));
        }
        String bucketName = request.getBucketName();
        String key = request.getKey();
        String accessId = this.credentials.getAccessKeyId();
        String accessKey = this.credentials.getAccessKeySecret();
        HttpMethod method = request.getMethod() != null ? request.getMethod() : HttpMethod.GET;
        String expires = String.valueOf(request.getExpiration().getTime() / 1000L);
        String resourcePath = OSSUtils.makeResourcePath(key);
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setEndpoint(OSSUtils.makeBukcetEndpoint(this.endpoint, bucketName));
        requestMessage.setMethod(method);
        requestMessage.setResourcePath(resourcePath);
        requestMessage.addHeader("Date", expires);
        if (request.getContentType() != null && request.getContentType().trim() != "") {
            requestMessage.addHeader("Content-Type", request.getContentType());
        }
        if (request.getContentMD5() != null && request.getContentMD5().trim() != "") {
            requestMessage.addHeader("Content-MD5", request.getContentMD5());
        }
        for (Map.Entry<String, String> h : request.getUserMetadata().entrySet()) {
            requestMessage.addHeader("x-oss-meta-" + h.getKey(), h.getValue());
        }
        Map<String, String> responseHeadersParams = OSSUtils.getResponseHeaderParameters(request.getResponseHeaders());
        if (responseHeadersParams.size() > 0) {
            requestMessage.setParameters(responseHeadersParams);
        }
        if (request.getQueryParameter() != null && request.getQueryParameter().size() > 0) {
            for (Map.Entry<String, String> entry : request.getQueryParameter().entrySet()) {
                requestMessage.addParameter(entry.getKey(), entry.getValue());
            }
        }
        String canonicalResource = "/" + (bucketName != null ? bucketName : "") + (key != null ? "/" + key : "");
        String canonicalString = SignUtils.buildCanonicalString(method.toString(), canonicalResource, requestMessage, expires);
        String signature = ServiceSignature.create().computeSignature(accessKey, canonicalString);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Expires", expires);
        params.put("OSSAccessKeyId", accessId);
        params.put("Signature", signature);
        params.putAll(requestMessage.getParameters());
        try {
            queryString = HttpUtil.paramToQueryString(params, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("FailedToEncodeUri"), e);
        }
        String url = requestMessage.getEndpoint().toString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + resourcePath + "?" + queryString;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest request) throws OSSException, ClientException {
        this.multipartOperation.abortMultipartUpload(request);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) throws OSSException, ClientException {
        return this.multipartOperation.completeMultipartUpload(request);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws OSSException, ClientException {
        return this.multipartOperation.initiateMultipartUpload(request);
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest request) throws OSSException, ClientException {
        return this.multipartOperation.listMultipartUploads(request);
    }

    @Override
    public PartListing listParts(ListPartsRequest request) throws OSSException, ClientException {
        return this.multipartOperation.listParts(request);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws OSSException, ClientException {
        return this.multipartOperation.uploadPart(request);
    }

    @Override
    public UploadPartCopyResult uploadPartCopy(UploadPartCopyRequest request) throws OSSException, ClientException {
        return this.multipartOperation.uploadPartCopy(request);
    }

    @Override
    public void setBucketCORS(SetBucketCORSRequest request) throws OSSException, ClientException {
        this.corsOperation.setBucketCORS(request);
    }

    @Override
    public List<SetBucketCORSRequest.CORSRule> getBucketCORSRules(String bucketName) throws OSSException, ClientException {
        return this.corsOperation.getBucketCORSRules(bucketName);
    }

    @Override
    public void deleteBucketCORSRules(String bucketName) throws OSSException, ClientException {
        this.corsOperation.deleteBucketCORS(bucketName);
    }

    @Override
    public ResponseMessage optionsObject(OptionsRequest request) throws OSSException, ClientException {
        return this.corsOperation.optionsObject(request);
    }

    @Override
    public void setBucketLogging(SetBucketLoggingRequest request) throws OSSException, ClientException {
        this.bucketOperation.setBucketLogging(request);
    }

    @Override
    public BucketLoggingResult getBucketLogging(String bucketName) {
        return this.bucketOperation.getBucketLogging(bucketName);
    }

    @Override
    public void deleteBucketLogging(String bucketName) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketLogging(bucketName);
    }

    @Override
    public void setBucketWebsite(SetBucketWebsiteRequest setBucketWebSiteRequest) throws OSSException, ClientException {
        this.bucketOperation.setBucketWebsite(setBucketWebSiteRequest);
    }

    @Override
    public BucketWebsiteResult getBucketWebsite(String bucketName) throws OSSException, ClientException {
        return this.bucketOperation.getBucketWebsite(bucketName);
    }

    @Override
    public void deleteBucketWebsite(String bucketName) throws OSSException, ClientException {
        this.bucketOperation.deleteBucketWebsite(bucketName);
    }
}

