/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.lookup.annotation.Named;

public class Threads {
    private static volatile Manager s_manager = new Manager();

    public static void addListener(ThreadListener listener) {
        s_manager.addListener(listener);
    }

    public static ThreadGroupManager forGroup() {
        return s_manager.getThreadGroupManager("Background");
    }

    public static ThreadGroupManager forGroup(String name) {
        return s_manager.getThreadGroupManager(name);
    }

    public static ThreadPoolManager forPool() {
        return s_manager.getThreadPoolManager();
    }

    public static void removeListener(ThreadListener listener) {
        s_manager.removeListener(listener);
    }

    public static class ThreadPoolManager {
        private Thread.UncaughtExceptionHandler m_handler;
        private Map<String, ExecutorService> m_services = new LinkedHashMap<String, ExecutorService>();

        public ThreadPoolManager(Thread.UncaughtExceptionHandler handler) {
            this.m_handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutorService getCachedThreadPool(String name) {
            ExecutorService service = this.m_services.get(name);
            if (service != null && service.isShutdown()) {
                this.m_services.remove(name);
                service = null;
            }
            if (service == null) {
                ThreadPoolManager threadPoolManager = this;
                synchronized (threadPoolManager) {
                    service = this.m_services.get(name);
                    if (service == null) {
                        DefaultThreadFactory factory = this.newThreadFactory(name);
                        service = Executors.newCachedThreadPool(factory);
                        this.m_services.put(name, service);
                        s_manager.onThreadPoolCreated(service, factory.getName());
                    }
                }
            }
            return service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutorService getFixedThreadPool(String name, int nThreads) {
            ExecutorService service = this.m_services.get(name);
            if (service != null && service.isShutdown()) {
                this.m_services.remove(name);
                service = null;
            }
            if (service == null) {
                ThreadPoolManager threadPoolManager = this;
                synchronized (threadPoolManager) {
                    service = this.m_services.get(name);
                    if (service == null) {
                        DefaultThreadFactory factory = this.newThreadFactory(name);
                        service = Executors.newFixedThreadPool(nThreads, factory);
                        this.m_services.put(name, service);
                        s_manager.onThreadPoolCreated(service, factory.getName());
                    }
                }
            }
            return service;
        }

        DefaultThreadFactory newThreadFactory(String name) {
            DefaultThreadFactory factory = new DefaultThreadFactory(name);
            factory.setUncaughtExceptionHandler(this.m_handler);
            return factory;
        }

        public void shutdownAll() {
            for (ExecutorService service : this.m_services.values()) {
                service.shutdown();
            }
            boolean allTerminated = false;
            int count = 100;
            while (!allTerminated && count-- > 0) {
                try {
                    for (ExecutorService service : this.m_services.values()) {
                        if (service.isTerminated()) continue;
                        service.awaitTermination(10L, TimeUnit.MILLISECONDS);
                    }
                    allTerminated = true;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static interface ThreadListener {
        public void onThreadGroupCreated(ThreadGroup var1, String var2);

        public void onThreadPoolCreated(ExecutorService var1, String var2);

        public void onThreadStarting(Thread var1, String var2);

        public void onThreadStopping(Thread var1, String var2);

        public boolean onUncaughtException(Thread var1, Throwable var2);
    }

    public static class ThreadGroupManager {
        private DefaultThreadFactory m_factory;
        private ThreadGroup m_threadGroup;
        private boolean m_active;

        public ThreadGroupManager(Thread.UncaughtExceptionHandler handler, String name) {
            this.m_threadGroup = new ThreadGroup(name);
            this.m_factory = new DefaultThreadFactory(this.m_threadGroup);
            this.m_factory.setUncaughtExceptionHandler(handler);
            this.m_active = true;
        }

        public boolean isActive() {
            return this.m_active;
        }

        public void awaitTermination(long time, TimeUnit unit) {
            long slice;
            for (long remaining = unit.toNanos(time); remaining > 0L; remaining -= slice) {
                int len = this.m_threadGroup.activeCount();
                Thread[] activeThreads = new Thread[len];
                int num = this.m_threadGroup.enumerate(activeThreads);
                boolean anyAlive = false;
                for (int i = 0; i < num; ++i) {
                    Thread thread = activeThreads[i];
                    if (!thread.isAlive()) continue;
                    anyAlive = true;
                    break;
                }
                if (!anyAlive) break;
                slice = 1000000L;
                LockSupport.parkNanos(slice);
            }
        }

        public ThreadGroup getThreadGroup() {
            return this.m_threadGroup;
        }

        public ThreadGroupManager nonDaemon() {
            return this;
        }

        public void shutdown() {
            int len = this.m_threadGroup.activeCount();
            Thread[] activeThreads = new Thread[len];
            int num = this.m_threadGroup.enumerate(activeThreads);
            for (int i = 0; i < num; ++i) {
                Thread thread = activeThreads[i];
                if (thread instanceof RunnableThread) {
                    ((RunnableThread)thread).shutdown();
                    continue;
                }
                if (!thread.isAlive()) continue;
                thread.interrupt();
            }
            this.m_active = false;
        }

        public Thread start(Runnable runnable) {
            return this.start(runnable, true);
        }

        public Thread start(Runnable runnable, boolean deamon) {
            Thread thread = this.m_factory.newThread(runnable);
            thread.setDaemon(deamon);
            thread.start();
            return thread;
        }
    }

    public static interface Task
    extends Runnable {
        public String getName();

        public void shutdown();
    }

    static class RunnableThread
    extends Thread {
        private Runnable m_target;

        public RunnableThread(ThreadGroup threadGroup, Runnable target, String name, Thread.UncaughtExceptionHandler handler) {
            super(threadGroup, target, name);
            this.m_target = target;
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(handler);
            if (this.getPriority() != 5) {
                this.setPriority(5);
            }
        }

        public Runnable getTarget() {
            return this.m_target;
        }

        @Override
        public void run() {
            s_manager.onThreadStarting(this, this.getName());
            super.run();
            s_manager.onThreadStopped(this, this.getName());
        }

        public void shutdown() {
            if (this.m_target instanceof Task) {
                System.out.println("shutdown task " + ((Task)this.m_target).getName());
                ((Task)this.m_target).shutdown();
            } else {
                this.interrupt();
            }
        }
    }

    static class Manager
    implements Thread.UncaughtExceptionHandler {
        private Map<String, ThreadGroupManager> m_groupManagers = new LinkedHashMap<String, ThreadGroupManager>();
        private List<ThreadListener> m_listeners = new ArrayList<ThreadListener>();
        private ThreadPoolManager m_threadPoolManager;

        public Manager() {
            Thread shutdownThread = new Thread(){

                @Override
                public void run() {
                    Manager.this.shutdownAll();
                }
            };
            this.m_threadPoolManager = new ThreadPoolManager(this);
            shutdownThread.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }

        public void addListener(ThreadListener listener) {
            this.m_listeners.add(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadGroupManager getThreadGroupManager(String name) {
            ThreadGroupManager groupManager = this.m_groupManagers.get(name);
            if (groupManager == null) {
                Manager manager = this;
                synchronized (manager) {
                    groupManager = this.m_groupManagers.get(name);
                    if (groupManager != null && !groupManager.isActive()) {
                        this.m_groupManagers.remove(name);
                        groupManager = null;
                    }
                    if (groupManager == null) {
                        groupManager = new ThreadGroupManager(this, name);
                        this.m_groupManagers.put(name, groupManager);
                        this.onThreadGroupCreated(groupManager.getThreadGroup(), name);
                    }
                }
            }
            return groupManager;
        }

        public ThreadPoolManager getThreadPoolManager() {
            return this.m_threadPoolManager;
        }

        public void onThreadGroupCreated(ThreadGroup group, String name) {
            for (ThreadListener listener : this.m_listeners) {
                try {
                    listener.onThreadGroupCreated(group, name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onThreadPoolCreated(ExecutorService service, String name) {
            for (ThreadListener listener : this.m_listeners) {
                try {
                    listener.onThreadPoolCreated(service, name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onThreadStarting(Thread thread, String name) {
            for (ThreadListener listener : this.m_listeners) {
                try {
                    listener.onThreadStarting(thread, name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onThreadStopped(Thread thread, String name) {
            for (ThreadListener listener : this.m_listeners) {
                try {
                    listener.onThreadStopping(thread, name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void removeListener(ThreadListener listener) {
            this.m_listeners.remove(listener);
        }

        public void shutdownAll() {
            for (ThreadGroupManager manager : this.m_groupManagers.values()) {
                manager.shutdown();
            }
            this.m_threadPoolManager.shutdownAll();
        }

        @Override
        public void uncaughtException(Thread thread, Throwable e) {
            ThreadListener listener;
            boolean handled;
            Iterator<ThreadListener> iterator = this.m_listeners.iterator();
            while (iterator.hasNext() && !(handled = (listener = iterator.next()).onUncaughtException(thread, e))) {
            }
        }
    }

    @Named(type=ThreadListener.class, value="logger")
    public static class LoggerThreadListener
    implements ThreadListener,
    LogEnabled {
        private Logger m_logger;

        public LoggerThreadListener() {
        }

        public LoggerThreadListener(Logger logger) {
            this.m_logger = logger;
        }

        @Override
        public void onThreadGroupCreated(ThreadGroup group, String name) {
            this.m_logger.info(String.format("Thread group(%s) created.", name));
        }

        @Override
        public void onThreadPoolCreated(ExecutorService pool, String name) {
            this.m_logger.info(String.format("Thread pool(%s) created.", name));
        }

        @Override
        public void onThreadStarting(Thread thread, String name) {
            this.m_logger.info(String.format("Starting thread(%s) ...", name));
        }

        @Override
        public void onThreadStopping(Thread thread, String name) {
            this.m_logger.info(String.format("Stopping thread(%s).", name));
        }

        @Override
        public boolean onUncaughtException(Thread thread, Throwable e) {
            this.m_logger.error(String.format("Uncaught exception thrown out of thread(%s).", thread.getName()), e);
            return true;
        }

        public void enableLogging(Logger logger) {
            this.m_logger = logger;
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private ThreadGroup m_threadGroup;
        private String m_name;
        private AtomicInteger m_index = new AtomicInteger();
        private Thread.UncaughtExceptionHandler m_handler;

        public DefaultThreadFactory(String name) {
            this.m_threadGroup = new ThreadGroup(name);
            this.m_name = name;
        }

        public DefaultThreadFactory(ThreadGroup threadGroup) {
            this.m_threadGroup = threadGroup;
            this.m_name = threadGroup.getName();
        }

        public String getName() {
            return this.m_name;
        }

        @Override
        public Thread newThread(Runnable r) {
            int nextIndex = this.m_index.getAndIncrement();
            String threadName = r instanceof Task ? this.m_name + "-" + ((Task)r).getName() : this.m_name + "-" + nextIndex;
            return new RunnableThread(this.m_threadGroup, r, threadName, this.m_handler);
        }

        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
            this.m_handler = handler;
        }
    }

    public static abstract class AbstractThreadListener
    implements ThreadListener {
        @Override
        public void onThreadGroupCreated(ThreadGroup group, String name) {
        }

        @Override
        public void onThreadPoolCreated(ExecutorService pool, String name) {
        }

        @Override
        public void onThreadStarting(Thread thread, String name) {
        }

        @Override
        public void onThreadStopping(Thread thread, String name) {
        }

        @Override
        public boolean onUncaughtException(Thread thread, Throwable e) {
            return false;
        }
    }
}

